/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';
export var LimitedSizeArray = function LimitedSizeArray(_ref) {
  var codec = _ref.codec,
      minSize = _ref.minSize,
      maxSize = _ref.maxSize,
      _ref$name = _ref.name,
      name = _ref$name === void 0 ? "LimitedSizeArray<".concat(codec.name, ">") : _ref$name;
  var arrType = t.array(codec);
  return new t.Type(name, arrType.is, function (input, context) {
    if (Array.isArray(input) && (minSize && input.length < minSize || maxSize && input.length > maxSize)) {
      return t.failure(input, context, "Array size (".concat(input.length, ") is out of bounds: min: ").concat(minSize !== null && minSize !== void 0 ? minSize : 'not specified', ", max: ").concat(maxSize !== null && maxSize !== void 0 ? maxSize : 'not specified'));
    } else {
      return arrType.validate(input, context);
    }
  }, t.identity);
};