/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';
import { either } from 'fp-ts/lib/Either';

/**
 * Types the StrongToPositiveNumber as:
 *   - If a string this converts the string into a number
 *   - Ensures it is a number (and not NaN)
 *   - Ensures it is positive number
 */
export var StringToPositiveNumber = new t.Type('StringToPositiveNumber', t.number.is, function (input, context) {
  return either.chain(t.string.validate(input, context), function (numberAsString) {
    var stringAsNumber = +numberAsString;

    if (numberAsString.trim().length === 0 || isNaN(stringAsNumber) || stringAsNumber <= 0) {
      return t.failure(input, context);
    } else {
      return t.success(stringAsNumber);
    }
  });
}, String);