import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _createForOfIteratorHelper from "@babel/runtime/helpers/createForOfIteratorHelper";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';

var isTimeSafe = function isTimeSafe(time) {
  return time >= 1 && Number.isSafeInteger(time);
};

export var TimeDuration = function TimeDuration(_ref) {
  var allowedUnits = _ref.allowedUnits,
      allowedDurations = _ref.allowedDurations;
  return new t.Type('TimeDuration', t.string.is, function (input, context) {
    if (typeof input === 'string' && input.trim() !== '') {
      try {
        var inputLength = input.length;
        var time = Number(input.trim().substring(0, inputLength - 1));
        var unit = input.trim().at(-1);

        if (!isTimeSafe(time)) {
          return t.failure(input, context);
        }

        if (allowedDurations) {
          var _iterator = _createForOfIteratorHelper(allowedDurations),
              _step;

          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var _step$value = _slicedToArray(_step.value, 2),
                  allowedTime = _step$value[0],
                  allowedUnit = _step$value[1];

              if (!isTimeSafe(allowedTime)) {
                return t.failure(allowedDurations, context);
              }

              if (allowedTime === time && allowedUnit === unit) {
                return t.success(input);
              }
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }

          return t.failure(input, context);
        } else if (allowedUnits.includes(unit)) {
          return t.success(input);
        } else {
          return t.failure(input, context);
        }
      } catch (error) {
        return t.failure(input, context);
      }
    } else {
      return t.failure(input, context);
    }
  }, t.identity);
};