"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.matchesOperator = exports.isOperator = exports.isOneOfOperator = exports.isNotOperator = exports.isNotOneOfOperator = exports.isNotInListOperator = exports.isInListOperator = exports.existsOperator = exports.doesNotMatchOperator = exports.doesNotExistOperator = exports.EXCEPTION_OPERATORS_SANS_LISTS = exports.EXCEPTION_OPERATORS_ONLY_LISTS = exports.EVENT_FILTERS_OPERATORS = exports.DETECTION_ENGINE_EXCEPTION_OPERATORS = exports.ALL_OPERATORS = void 0;

var _i18n = require("@kbn/i18n");

var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const isOperator = {
  message: _i18n.i18n.translate('lists.exceptions.isOperatorLabel', {
    defaultMessage: 'is'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.INCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH,
  value: 'is'
};
exports.isOperator = isOperator;
const isNotOperator = {
  message: _i18n.i18n.translate('lists.exceptions.isNotOperatorLabel', {
    defaultMessage: 'is not'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.EXCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH,
  value: 'is_not'
};
exports.isNotOperator = isNotOperator;
const isOneOfOperator = {
  message: _i18n.i18n.translate('lists.exceptions.isOneOfOperatorLabel', {
    defaultMessage: 'is one of'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.INCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH_ANY,
  value: 'is_one_of'
};
exports.isOneOfOperator = isOneOfOperator;
const isNotOneOfOperator = {
  message: _i18n.i18n.translate('lists.exceptions.isNotOneOfOperatorLabel', {
    defaultMessage: 'is not one of'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.EXCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH_ANY,
  value: 'is_not_one_of'
};
exports.isNotOneOfOperator = isNotOneOfOperator;
const existsOperator = {
  message: _i18n.i18n.translate('lists.exceptions.existsOperatorLabel', {
    defaultMessage: 'exists'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.INCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.EXISTS,
  value: 'exists'
};
exports.existsOperator = existsOperator;
const doesNotExistOperator = {
  message: _i18n.i18n.translate('lists.exceptions.doesNotExistOperatorLabel', {
    defaultMessage: 'does not exist'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.EXCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.EXISTS,
  value: 'does_not_exist'
};
exports.doesNotExistOperator = doesNotExistOperator;
const isInListOperator = {
  message: _i18n.i18n.translate('lists.exceptions.isInListOperatorLabel', {
    defaultMessage: 'is in list'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.INCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.LIST,
  value: 'is_in_list'
};
exports.isInListOperator = isInListOperator;
const isNotInListOperator = {
  message: _i18n.i18n.translate('lists.exceptions.isNotInListOperatorLabel', {
    defaultMessage: 'is not in list'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.EXCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.LIST,
  value: 'is_not_in_list'
};
exports.isNotInListOperator = isNotInListOperator;
const matchesOperator = {
  message: _i18n.i18n.translate('lists.exceptions.matchesOperatorLabel', {
    defaultMessage: 'matches'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.INCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.WILDCARD,
  value: 'matches'
};
exports.matchesOperator = matchesOperator;
const doesNotMatchOperator = {
  message: _i18n.i18n.translate('lists.exceptions.doesNotMatchOperatorLabel', {
    defaultMessage: 'does not match'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.EXCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.WILDCARD,
  value: 'does_not_match'
};
exports.doesNotMatchOperator = doesNotMatchOperator;
const EVENT_FILTERS_OPERATORS = [isOperator, isNotOperator, isOneOfOperator, isNotOneOfOperator, matchesOperator];
/*
 * !IMPORTANT! - Please only add to this list if it is an operator
 * supported by the detection engine.
 */

exports.EVENT_FILTERS_OPERATORS = EVENT_FILTERS_OPERATORS;
const DETECTION_ENGINE_EXCEPTION_OPERATORS = [isOperator, isNotOperator, isOneOfOperator, isNotOneOfOperator, existsOperator, doesNotExistOperator, isInListOperator, isNotInListOperator, matchesOperator, doesNotMatchOperator];
exports.DETECTION_ENGINE_EXCEPTION_OPERATORS = DETECTION_ENGINE_EXCEPTION_OPERATORS;
const ALL_OPERATORS = [isOperator, isNotOperator, isOneOfOperator, isNotOneOfOperator, existsOperator, doesNotExistOperator, isInListOperator, isNotInListOperator, matchesOperator, doesNotMatchOperator];
exports.ALL_OPERATORS = ALL_OPERATORS;
const EXCEPTION_OPERATORS_SANS_LISTS = [isOperator, isNotOperator, isOneOfOperator, isNotOneOfOperator, existsOperator, doesNotExistOperator, matchesOperator, doesNotMatchOperator];
exports.EXCEPTION_OPERATORS_SANS_LISTS = EXCEPTION_OPERATORS_SANS_LISTS;
const EXCEPTION_OPERATORS_ONLY_LISTS = [isInListOperator, isNotInListOperator];
exports.EXCEPTION_OPERATORS_ONLY_LISTS = EXCEPTION_OPERATORS_ONLY_LISTS;