"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExceptionListType = void 0;

var _types = require("../types");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const getExceptionListType = ({
  savedObjectType
}) => {
  if (savedObjectType === _types.exceptionListAgnosticSavedObjectType) {
    return 'agnostic';
  } else {
    return 'single';
  }
};

exports.getExceptionListType = getExceptionListType;