/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { parseEndpoint } from './parse_endpoint';
export function formatRequest(endpoint) {
  var pathParams = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  var _parseEndpoint = parseEndpoint(endpoint),
      method = _parseEndpoint.method,
      rawPathname = _parseEndpoint.pathname; // replace template variables with path params


  var pathname = Object.keys(pathParams).reduce(function (acc, paramName) {
    return acc.replace("{".concat(paramName, "}"), pathParams[paramName]);
  }, rawPathname);
  return {
    method: method,
    pathname: pathname
  };
}