import _extends from "@babel/runtime/helpers/extends";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React, { Suspense } from 'react';
import { EuiErrorBoundary } from '@elastic/eui';
import { Fallback } from './fallback';
/**
 * A HOC which supplies React.Suspense with a fallback component, and a `EuiErrorBoundary` to contain errors.
 * @param Component A component deferred by `React.lazy`
 * @param fallback A fallback component to render while things load; default is `Fallback` from SharedUX.
 */

import { jsx as ___EmotionJSX } from "@emotion/react";
export var withSuspense = function withSuspense(Component) {
  var fallback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : ___EmotionJSX(Fallback, null);
  return /*#__PURE__*/React.forwardRef(function (props, ref) {
    return ___EmotionJSX(EuiErrorBoundary, null, ___EmotionJSX(Suspense, {
      fallback: fallback
    }, ___EmotionJSX(Component, _extends({}, props, {
      ref: ref
    }))));
  });
};