"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.kibanaPackageJson = exports.isKibanaDistributable = void 0;

var _path = _interopRequireDefault(require("path"));

var _fs = _interopRequireDefault(require("fs"));

var _repo_root = require("../repo_root");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function parseKibanaPackageJson() {
  const path = _path.default.resolve(_repo_root.REPO_ROOT, 'package.json');

  const json = _fs.default.readFileSync(path, 'utf8');

  let pkg;

  try {
    pkg = JSON.parse(json);
  } catch (error) {
    throw new Error(`unable to parse kibana's package.json file: ${error.message}`);
  }

  return pkg;
}

const kibanaPackageJson = parseKibanaPackageJson();
exports.kibanaPackageJson = kibanaPackageJson;

const isKibanaDistributable = () => {
  return kibanaPackageJson.build.distributable === true;
};

exports.isKibanaDistributable = isKibanaDistributable;