"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromRoot = exports.UPSTREAM_BRANCH = exports.REPO_ROOT = void 0;

var _path = _interopRequireDefault(require("path"));

var _fs = _interopRequireDefault(require("fs"));

var _loadJsonFile = _interopRequireDefault(require("load-json-file"));

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const readKibanaPkgJson = path => {
  try {
    const json = _loadJsonFile.default.sync(path);

    if (json && typeof json === 'object' && 'name' in json && json.name === 'kibana') {
      return json;
    }
  } catch (error) {
    if (error && error.code === 'ENOENT') {
      return;
    }

    throw error;
  }
};

const findKibanaPackageJson = () => {
  // search for the kibana directory, since this file is moved around it might
  // not be where we think but should always be a relatively close parent
  // of this directory
  const startDir = __dirname;

  const {
    root: rootDir
  } = _path.default.parse(startDir);

  let cursor = startDir;

  while (true) {
    const packageJsonPath = _path.default.resolve(cursor, 'package.json');

    const kibanaPkgJson = readKibanaPkgJson(packageJsonPath);

    if (kibanaPkgJson) {
      return {
        // when this script is run by ESLint in IDEs it doesn't use --preserve-symlinks, so we have to
        // use `Fs.realpathSync()` to resolve the package.json path to the actual file in the repo rather
        // than the sym-linked version in the bazel-out dir
        kibanaDir: _path.default.dirname(_fs.default.realpathSync(packageJsonPath)),
        kibanaPkgJson: kibanaPkgJson
      };
    }

    const parent = _path.default.dirname(cursor);

    if (parent === rootDir) {
      throw new Error(`unable to find kibana directory from ${startDir}`);
    }

    cursor = parent;
  }
};

const {
  kibanaDir,
  kibanaPkgJson
} = findKibanaPackageJson();
const REPO_ROOT = kibanaDir;
exports.REPO_ROOT = REPO_ROOT;
const UPSTREAM_BRANCH = kibanaPkgJson.branch;
exports.UPSTREAM_BRANCH = UPSTREAM_BRANCH;

const fromRoot = (...paths) => _path.default.resolve(REPO_ROOT, ...paths);

exports.fromRoot = fromRoot;