"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoreRouteHandlerContext = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _coreElasticsearchServerInternal = require("@kbn/core-elasticsearch-server-internal");

var _coreSavedObjectsServerInternal = require("@kbn/core-saved-objects-server-internal");

var _coreDeprecationsServerInternal = require("@kbn/core-deprecations-server-internal");

var _coreUiSettingsServerInternal = require("@kbn/core-ui-settings-server-internal");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * The concrete implementation for Core's route handler context.
 *
 * @internal
 */
class CoreRouteHandlerContext {
  constructor(coreStart, request) {
    (0, _defineProperty2.default)(this, "elasticsearch", void 0);
    (0, _defineProperty2.default)(this, "savedObjects", void 0);
    (0, _defineProperty2.default)(this, "uiSettings", void 0);
    (0, _defineProperty2.default)(this, "deprecations", void 0);
    this.elasticsearch = new _coreElasticsearchServerInternal.CoreElasticsearchRouteHandlerContext(coreStart.elasticsearch, request);
    this.savedObjects = new _coreSavedObjectsServerInternal.CoreSavedObjectsRouteHandlerContext(coreStart.savedObjects, request);
    this.uiSettings = new _coreUiSettingsServerInternal.CoreUiSettingsRouteHandlerContext(coreStart.uiSettings, this.savedObjects);
    this.deprecations = new _coreDeprecationsServerInternal.CoreDeprecationsRouteHandlerContext(coreStart.deprecations, this.elasticsearch, this.savedObjects);
  }

}

exports.CoreRouteHandlerContext = CoreRouteHandlerContext;