"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.queryStateToExpressionAst = queryStateToExpressionAst;

var _esQuery = require("@kbn/es-query");

var _common = require("../../../expressions/common");

var _ = require("..");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Converts QueryState to expression AST
 * @param filters array of kibana filters
 * @param query kibana query or aggregate query
 * @param time kibana time range
 */
async function queryStateToExpressionAst({
  filters,
  query,
  inputQuery,
  time,
  dataViewsService
}) {
  const kibana = (0, _common.buildExpressionFunction)('kibana', {});
  let q;

  if (inputQuery) {
    q = inputQuery;
  }

  const kibanaContext = (0, _common.buildExpressionFunction)('kibana_context', {
    q: q && (0, _.queryToAst)(q),
    timeRange: time && (0, _.timerangeToAst)(time),
    filters: filters && (0, _.filtersToAst)(filters)
  });
  const ast = (0, _common.buildExpression)([kibana, kibanaContext]).toAst();

  if (query && (0, _esQuery.isOfAggregateQueryType)(query)) {
    const mode = (0, _esQuery.getAggregateQueryMode)(query); // sql query

    if (mode === 'sql' && 'sql' in query) {
      const idxPattern = (0, _esQuery.getIndexPatternFromSQLQuery)(query.sql);
      const idsTitles = await dataViewsService.getIdsWithTitle();
      const dataViewIdTitle = idsTitles.find(({
        title
      }) => title === idxPattern);

      if (dataViewIdTitle) {
        const dataView = await dataViewsService.get(dataViewIdTitle.id);
        const timeFieldName = dataView.timeFieldName;
        const essql = (0, _.aggregateQueryToAst)(query, timeFieldName);

        if (essql) {
          ast.chain.push(essql);
        }
      } else {
        throw new Error(`No data view found for index pattern ${idxPattern}`);
      }
    }
  }

  return ast;
}