"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineRoutes = defineRoutes;

var _configSchema = require("@kbn/config-schema");

var _saved_objects = require("../saved_objects");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const doesGuidedSetupExist = async savedObjectsClient => {
  return savedObjectsClient.find({
    type: _saved_objects.guidedSetupSavedObjectsType
  }).then(foundSavedObjects => foundSavedObjects.total > 0);
};

function defineRoutes(router) {
  router.get({
    path: '/api/guided_onboarding/state',
    validate: false
  }, async (context, request, response) => {
    const coreContext = await context.core;
    const soClient = coreContext.savedObjects.client;
    const stateExists = await doesGuidedSetupExist(soClient);

    if (stateExists) {
      const guidedSetupSO = await soClient.get(_saved_objects.guidedSetupSavedObjectsType, _saved_objects.guidedSetupSavedObjectsId);
      return response.ok({
        body: {
          state: guidedSetupSO.attributes
        }
      });
    } else {
      return response.ok({
        body: {
          state: _saved_objects.guidedSetupDefaultState
        }
      });
    }
  });
  router.put({
    path: '/api/guided_onboarding/state',
    validate: {
      body: _configSchema.schema.object({
        activeGuide: _configSchema.schema.maybe(_configSchema.schema.string()),
        activeStep: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, async (context, request, response) => {
    const activeGuide = request.body.activeGuide;
    const activeStep = request.body.activeStep;
    const attributes = {
      activeGuide: activeGuide !== null && activeGuide !== void 0 ? activeGuide : 'unset',
      activeStep: activeStep !== null && activeStep !== void 0 ? activeStep : 'unset'
    };
    const coreContext = await context.core;
    const soClient = coreContext.savedObjects.client;
    const stateExists = await doesGuidedSetupExist(soClient);

    if (stateExists) {
      const updatedGuidedSetupSO = await soClient.update(_saved_objects.guidedSetupSavedObjectsType, _saved_objects.guidedSetupSavedObjectsId, attributes);
      return response.ok({
        body: {
          state: updatedGuidedSetupSO.attributes
        }
      });
    } else {
      const guidedSetupSO = await soClient.create(_saved_objects.guidedSetupSavedObjectsType, { ..._saved_objects.guidedSetupDefaultState,
        ...attributes
      }, {
        id: _saved_objects.guidedSetupSavedObjectsId
      });
      return response.ok({
        body: {
          state: guidedSetupSO.attributes
        }
      });
    }
  });
}