"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.guidedSetupSavedObjectsType = exports.guidedSetupSavedObjectsId = exports.guidedSetupSavedObjects = exports.guidedSetupDefaultState = void 0;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const guidedSetupSavedObjectsType = 'guided-setup-state';
exports.guidedSetupSavedObjectsType = guidedSetupSavedObjectsType;
const guidedSetupSavedObjectsId = 'guided-setup-state-id';
exports.guidedSetupSavedObjectsId = guidedSetupSavedObjectsId;
const guidedSetupDefaultState = {
  activeGuide: 'unset',
  activeStep: 'unset'
};
exports.guidedSetupDefaultState = guidedSetupDefaultState;
const guidedSetupSavedObjects = {
  name: guidedSetupSavedObjectsType,
  hidden: false,
  // make it available in all spaces for now
  namespaceType: 'agnostic',
  mappings: {
    dynamic: false,
    properties: {
      activeGuide: {
        type: 'keyword'
      },
      activeStep: {
        type: 'keyword'
      }
    }
  }
};
exports.guidedSetupSavedObjects = guidedSetupSavedObjects;