"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchBooleanFieldStats = void 0;

var _get_common_correlations_query = require("../get_common_correlations_query");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const fetchBooleanFieldStats = async ({
  setup,
  eventType,
  start,
  end,
  environment,
  kuery,
  field,
  query
}) => {
  var _aggregations$sampled, _aggregations$sampled2, _aggregations$sampled3;

  const {
    apmEventClient
  } = setup;
  const {
    fieldName
  } = field;
  const {
    aggregations
  } = await apmEventClient.search('get_boolean_field_stats', {
    apm: {
      events: [eventType]
    },
    body: {
      size: 0,
      track_total_hits: false,
      query: (0, _get_common_correlations_query.getCommonCorrelationsQuery)({
        start,
        end,
        environment,
        kuery,
        query
      }),
      aggs: {
        sampled_value_count: {
          filter: {
            exists: {
              field: fieldName
            }
          }
        },
        sampled_values: {
          terms: {
            field: fieldName,
            size: 2
          }
        }
      }
    }
  });
  const stats = {
    fieldName: field.fieldName,
    count: (_aggregations$sampled = aggregations === null || aggregations === void 0 ? void 0 : aggregations.sampled_value_count.doc_count) !== null && _aggregations$sampled !== void 0 ? _aggregations$sampled : 0
  };
  const valueBuckets = (_aggregations$sampled2 = aggregations === null || aggregations === void 0 ? void 0 : (_aggregations$sampled3 = aggregations.sampled_values) === null || _aggregations$sampled3 === void 0 ? void 0 : _aggregations$sampled3.buckets) !== null && _aggregations$sampled2 !== void 0 ? _aggregations$sampled2 : [];
  valueBuckets.forEach(bucket => {
    stats[`${bucket.key.toString()}Count`] = bucket.doc_count;
  });
  return stats;
};

exports.fetchBooleanFieldStats = fetchBooleanFieldStats;