"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchFieldValueFieldStats = void 0;

var _get_common_correlations_query = require("../get_common_correlations_query");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const fetchFieldValueFieldStats = async ({
  setup,
  eventType,
  start,
  end,
  environment,
  kuery,
  query,
  field
}) => {
  var _aggregations$filtere, _aggregations$filtere2;

  const {
    apmEventClient
  } = setup;
  const {
    aggregations
  } = await apmEventClient.search('get_field_value_field_stats', {
    apm: {
      events: [eventType]
    },
    body: {
      size: 0,
      track_total_hits: false,
      query: (0, _get_common_correlations_query.getCommonCorrelationsQuery)({
        start,
        end,
        environment,
        kuery,
        query
      }),
      aggs: {
        filtered_count: {
          filter: {
            term: {
              [`${field === null || field === void 0 ? void 0 : field.fieldName}`]: field === null || field === void 0 ? void 0 : field.fieldValue
            }
          }
        }
      }
    }
  });
  const topValues = [{
    key: field.fieldValue,
    doc_count: (_aggregations$filtere = aggregations === null || aggregations === void 0 ? void 0 : aggregations.filtered_count.doc_count) !== null && _aggregations$filtere !== void 0 ? _aggregations$filtere : 0
  }];
  const stats = {
    fieldName: field.fieldName,
    topValues,
    topValuesSampleSize: (_aggregations$filtere2 = aggregations === null || aggregations === void 0 ? void 0 : aggregations.filtered_count.doc_count) !== null && _aggregations$filtere2 !== void 0 ? _aggregations$filtere2 : 0
  };
  return stats;
};

exports.fetchFieldValueFieldStats = fetchFieldValueFieldStats;