"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteMlInferencePipeline = void 0;

var _ml_inference_pipeline_utils = require("../../utils/ml_inference_pipeline_utils");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const deleteMlInferencePipeline = async (indexName, pipelineName, client) => {
  const response = {};
  const parentPipelineId = (0, _ml_inference_pipeline_utils.getInferencePipelineNameFromIndexName)(indexName); // find parent pipeline

  try {
    const pipelineResponse = await client.ingest.getPipeline({
      id: parentPipelineId
    });
    const parentPipeline = pipelineResponse[parentPipelineId];

    if (parentPipeline !== undefined) {
      // remove sub-pipeline from parent pipeline
      if (parentPipeline.processors !== undefined) {
        const updatedProcessors = parentPipeline.processors.filter(p => !(p.pipeline !== undefined && p.pipeline.name === pipelineName)); // only update if we changed something

        if (updatedProcessors.length !== parentPipeline.processors.length) {
          const updatedPipeline = { ...parentPipeline,
            id: parentPipelineId,
            processors: updatedProcessors
          };
          const updateResponse = await client.ingest.putPipeline(updatedPipeline);

          if (updateResponse.acknowledged === true) {
            response.updated = parentPipelineId;
          }
        }
      }
    }
  } catch (error) {
    var _error$meta;

    // only suppress Not Found error
    if (((_error$meta = error.meta) === null || _error$meta === void 0 ? void 0 : _error$meta.statusCode) !== 404) {
      throw error;
    }
  } // finally, delete pipeline


  const deleteResponse = await client.ingest.deletePipeline({
    id: pipelineName
  });

  if (deleteResponse.acknowledged === true) {
    response.deleted = pipelineName;
  }

  return response;
};

exports.deleteMlInferencePipeline = deleteMlInferencePipeline;