"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPrefixedInferencePipelineProcessorName = exports.getInferencePipelineNameFromIndexName = exports.formatPipelineName = void 0;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getInferencePipelineNameFromIndexName = indexName => `${indexName}@ml-inference`;

exports.getInferencePipelineNameFromIndexName = getInferencePipelineNameFromIndexName;

const getPrefixedInferencePipelineProcessorName = pipelineName => pipelineName.startsWith('ml-inference-') ? formatPipelineName(pipelineName) : `ml-inference-${formatPipelineName(pipelineName)}`;

exports.getPrefixedInferencePipelineProcessorName = getPrefixedInferencePipelineProcessorName;

const formatPipelineName = rawName => rawName.trim().replace(/\s+/g, '_') // Convert whitespaces to underscores
.toLowerCase();

exports.formatPipelineName = formatPipelineName;