"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateAgentTags = updateAgentTags;

var _errors = require("../../errors");

var _constants = require("../../constants");

var _crud = require("./crud");

var _helpers = require("./helpers");

var _update_agent_tags_action_runner = require("./update_agent_tags_action_runner");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function isMgetDoc(doc) {
  return Boolean(doc && 'found' in doc);
}

async function updateAgentTags(soClient, esClient, options, tagsToAdd, tagsToRemove) {
  const outgoingErrors = {};
  let givenAgents = [];

  if ('agentIds' in options) {
    const givenAgentsResults = await (0, _crud.getAgentDocuments)(esClient, options.agentIds);

    for (const agentResult of givenAgentsResults) {
      if (isMgetDoc(agentResult) && agentResult.found === false) {
        outgoingErrors[agentResult._id] = new _errors.AgentReassignmentError(`Cannot find agent ${agentResult._id}`);
      } else {
        givenAgents.push((0, _helpers.searchHitToAgent)(agentResult));
      }
    }
  } else if ('kuery' in options) {
    var _options$batchSize, _options$showInactive;

    const batchSize = (_options$batchSize = options.batchSize) !== null && _options$batchSize !== void 0 ? _options$batchSize : _constants.SO_SEARCH_LIMIT;
    const res = await (0, _crud.getAgentsByKuery)(esClient, {
      kuery: options.kuery,
      showInactive: (_options$showInactive = options.showInactive) !== null && _options$showInactive !== void 0 ? _options$showInactive : false,
      page: 1,
      perPage: batchSize
    });

    if (res.total <= batchSize) {
      givenAgents = res.agents;
    } else {
      return await new _update_agent_tags_action_runner.UpdateAgentTagsActionRunner(esClient, soClient, { ...options,
        batchSize,
        total: res.total,
        tagsToAdd,
        tagsToRemove
      }, {
        pitId: await (0, _crud.openPointInTime)(esClient)
      }).runActionAsyncWithRetry();
    }
  }

  return await (0, _update_agent_tags_action_runner.updateTagsBatch)(soClient, esClient, givenAgents, outgoingErrors, {
    tagsToAdd,
    tagsToRemove
  });
}