"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSLOMappingsTemplate = void 0;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getSLOMappingsTemplate = name => ({
  name,
  template: {
    mappings: {
      properties: {
        '@timestamp': {
          type: 'date',
          format: 'date_optional_time||epoch_millis'
        },
        slo: {
          properties: {
            id: {
              type: 'keyword',
              ignore_above: 256
            },
            numerator: {
              type: 'long'
            },
            denominator: {
              type: 'long'
            },
            context: {
              type: 'flattened'
            }
          }
        }
      }
    }
  },
  _meta: {
    description: 'Mappings for SLO rollup data',
    version: 1
  }
});

exports.getSLOMappingsTemplate = getSLOMappingsTemplate;