"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaSavedObjectsSLORepository = void 0;

var _coreSavedObjectsUtilsServer = require("@kbn/core-saved-objects-utils-server");

var _saved_objects = require("../../saved_objects");

var _errors = require("../../errors");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class KibanaSavedObjectsSLORepository {
  constructor(soClient) {
    this.soClient = soClient;
  }

  async save(slo) {
    const now = new Date().toISOString();
    const savedSLO = await this.soClient.create(_saved_objects.SO_SLO_TYPE, { ...slo,
      created_at: now,
      updated_at: now
    }, {
      id: slo.id
    });
    return toSLOModel(savedSLO.attributes);
  }

  async findById(id) {
    try {
      const slo = await this.soClient.get(_saved_objects.SO_SLO_TYPE, id);
      return toSLOModel(slo.attributes);
    } catch (err) {
      if (_coreSavedObjectsUtilsServer.SavedObjectsErrorHelpers.isNotFoundError(err)) {
        throw new _errors.SLONotFound(`SLO [${id}] not found`);
      }

      throw err;
    }
  }

  async deleteById(id) {
    try {
      await this.soClient.delete(_saved_objects.SO_SLO_TYPE, id);
    } catch (err) {
      if (_coreSavedObjectsUtilsServer.SavedObjectsErrorHelpers.isNotFoundError(err)) {
        throw new _errors.SLONotFound(`SLO [${id}] not found`);
      }

      throw err;
    }
  }

}

exports.KibanaSavedObjectsSLORepository = KibanaSavedObjectsSLORepository;

function toSLOModel(slo) {
  return {
    id: slo.id,
    name: slo.name,
    description: slo.description,
    indicator: slo.indicator,
    time_window: slo.time_window,
    budgeting_method: slo.budgeting_method,
    objective: slo.objective
  };
}