"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initAPIAuthorization = initAPIAuthorization;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function initAPIAuthorization(http, {
  actions,
  checkPrivilegesDynamicallyWithRequest,
  mode
}, logger) {
  http.registerOnPostAuth(async (request, response, toolkit) => {
    // if we aren't using RBAC for this request, just continue
    if (!mode.useRbacForRequest(request)) {
      return toolkit.next();
    }

    const tags = request.route.options.tags;
    const tagPrefix = 'access:';
    const actionTags = tags.filter(tag => tag.startsWith(tagPrefix)); // if there are no tags starting with "access:", just continue

    if (actionTags.length === 0) {
      return toolkit.next();
    }

    const apiActions = actionTags.map(tag => actions.api.get(tag.substring(tagPrefix.length)));
    const checkPrivileges = checkPrivilegesDynamicallyWithRequest(request);
    const checkPrivilegesResponse = await checkPrivileges({
      kibana: apiActions
    }); // we've actually authorized the request

    if (checkPrivilegesResponse.hasAllRequested) {
      logger.debug(`User authorized for "${request.url.pathname}${request.url.search}"`);
      return toolkit.next();
    }

    logger.warn(`User not authorized for "${request.url.pathname}${request.url.search}": responding with 403`);
    return response.forbidden();
  });
}