"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.throttleForBulkActions = exports.performBulkActionSchema = exports.performBulkActionQuerySchema = exports.bulkActionEditPayload = exports.bulkAction = exports.BulkActionEditType = exports.BulkAction = void 0;

var t = _interopRequireWildcard(require("io-ts"));

var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");

var _securitysolutionIoTsAlertingTypes = require("@kbn/securitysolution-io-ts-alerting-types");

var _schemas = require("../common/schemas");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let BulkAction;
exports.BulkAction = BulkAction;

(function (BulkAction) {
  BulkAction["enable"] = "enable";
  BulkAction["disable"] = "disable";
  BulkAction["export"] = "export";
  BulkAction["delete"] = "delete";
  BulkAction["duplicate"] = "duplicate";
  BulkAction["edit"] = "edit";
})(BulkAction || (exports.BulkAction = BulkAction = {}));

const bulkAction = (0, _securitysolutionIoTsTypes.enumeration)('BulkAction', BulkAction);
exports.bulkAction = bulkAction;
let BulkActionEditType;
exports.BulkActionEditType = BulkActionEditType;

(function (BulkActionEditType) {
  BulkActionEditType["add_tags"] = "add_tags";
  BulkActionEditType["delete_tags"] = "delete_tags";
  BulkActionEditType["set_tags"] = "set_tags";
  BulkActionEditType["add_index_patterns"] = "add_index_patterns";
  BulkActionEditType["delete_index_patterns"] = "delete_index_patterns";
  BulkActionEditType["set_index_patterns"] = "set_index_patterns";
  BulkActionEditType["set_timeline"] = "set_timeline";
  BulkActionEditType["add_rule_actions"] = "add_rule_actions";
  BulkActionEditType["set_rule_actions"] = "set_rule_actions";
  BulkActionEditType["set_schedule"] = "set_schedule";
})(BulkActionEditType || (exports.BulkActionEditType = BulkActionEditType = {}));

const throttleForBulkActions = t.union([t.literal('rule'), (0, _securitysolutionIoTsTypes.TimeDuration)({
  allowedDurations: [[1, 'h'], [1, 'd'], [7, 'd']]
})]);
exports.throttleForBulkActions = throttleForBulkActions;
const bulkActionEditPayloadTags = t.type({
  type: t.union([t.literal(BulkActionEditType.add_tags), t.literal(BulkActionEditType.delete_tags), t.literal(BulkActionEditType.set_tags)]),
  value: _schemas.tags
});
const bulkActionEditPayloadIndexPatterns = t.intersection([t.type({
  type: t.union([t.literal(BulkActionEditType.add_index_patterns), t.literal(BulkActionEditType.delete_index_patterns), t.literal(BulkActionEditType.set_index_patterns)]),
  value: _schemas.index
}), t.exact(t.partial({
  overwrite_data_views: t.boolean
}))]);
const bulkActionEditPayloadTimeline = t.type({
  type: t.literal(BulkActionEditType.set_timeline),
  value: t.type({
    timeline_id: _schemas.timeline_id,
    timeline_title: _schemas.timeline_title
  })
});

/**
 * per rulesClient.bulkEdit rules actions operation contract (x-pack/plugins/alerting/server/rules_client/rules_client.ts)
 * normalized rule action object is expected (NormalizedAlertAction) as value for the edit operation
 */
const normalizedRuleAction = t.exact(t.type({
  group: _securitysolutionIoTsAlertingTypes.action_group,
  id: _securitysolutionIoTsAlertingTypes.action_id,
  params: _securitysolutionIoTsAlertingTypes.action_params
}));
const bulkActionEditPayloadRuleActions = t.type({
  type: t.union([t.literal(BulkActionEditType.add_rule_actions), t.literal(BulkActionEditType.set_rule_actions)]),
  value: t.type({
    throttle: throttleForBulkActions,
    actions: t.array(normalizedRuleAction)
  })
});
const bulkActionEditPayloadSchedule = t.type({
  type: t.literal(BulkActionEditType.set_schedule),
  value: t.type({
    interval: (0, _securitysolutionIoTsTypes.TimeDuration)({
      allowedUnits: ['s', 'm', 'h']
    }),
    lookback: (0, _securitysolutionIoTsTypes.TimeDuration)({
      allowedUnits: ['s', 'm', 'h']
    })
  })
});
const bulkActionEditPayload = t.union([bulkActionEditPayloadTags, bulkActionEditPayloadIndexPatterns, bulkActionEditPayloadTimeline, bulkActionEditPayloadRuleActions, bulkActionEditPayloadSchedule]);
exports.bulkActionEditPayload = bulkActionEditPayload;
const performBulkActionSchema = t.intersection([t.exact(t.type({
  query: _schemas.queryOrUndefined
})), t.exact(t.partial({
  ids: (0, _securitysolutionIoTsTypes.NonEmptyArray)(t.string)
})), t.union([t.exact(t.type({
  action: t.union([t.literal(BulkAction.delete), t.literal(BulkAction.disable), t.literal(BulkAction.duplicate), t.literal(BulkAction.enable), t.literal(BulkAction.export)])
})), t.exact(t.type({
  action: t.literal(BulkAction.edit),
  [BulkAction.edit]: (0, _securitysolutionIoTsTypes.NonEmptyArray)(bulkActionEditPayload)
}))])]);
exports.performBulkActionSchema = performBulkActionSchema;
const performBulkActionQuerySchema = t.exact(t.partial({
  dry_run: t.union([t.literal('true'), t.literal('false')])
}));
exports.performBulkActionQuerySchema = performBulkActionQuerySchema;