"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDataStreamBackingIndex = void 0;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @remark
 * WARNING!
 *
 * This is a very hacky way of determining whether an index is a backing index.
 *
 * We only do this so that we can show users during a snapshot restore workflow
 * that an index is part of a data stream. At the moment there is no way for us
 * to get this information from the snapshot itself, even though it contains the
 * metadata for the data stream that information is fully opaque to us until after
 * we have done the snapshot restore.
 *
 * Issue for tracking this discussion here: https://github.com/elastic/elasticsearch/issues/58890
 */
const isDataStreamBackingIndex = indexName => {
  return indexName.startsWith('.ds');
};

exports.isDataStreamBackingIndex = isDataStreamBackingIndex;