"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiDescriptionListStyles = void 0;

var _react = require("@emotion/react");

var _global_styling = require("../../global_styling");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var euiDescriptionListStyles = function euiDescriptionListStyles(euiThemeContext) {
  // Flex display for column and responsive column
  var columnDisplay = "\n    display: flex;\n    align-items: baseline;\n    flex-wrap: wrap;  \n  ";
  return {
    euiDescriptionList: /*#__PURE__*/(0, _react.css)(";label:euiDescriptionList;"),
    // Types
    row: /*#__PURE__*/(0, _react.css)(";label:row;"),
    inline: /*#__PURE__*/(0, _react.css)(";label:inline;"),
    column: /*#__PURE__*/(0, _react.css)(columnDisplay, ";;label:column;"),
    // Responsive columns behave as a row on breakpoints xs-s
    responsiveColumn: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiBreakpoint)(euiThemeContext, ['m', 'xl']), "{", columnDisplay, ";};label:responsiveColumn;"),
    // Alignment
    center: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalTextAlignCSS)('center'), ";;label:center;"),
    left: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalTextAlignCSS)('left'), ";;label:left;")
  };
};

exports.euiDescriptionListStyles = euiDescriptionListStyles;