"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TYPES = exports.SIZES = exports.SIDES = exports.PADDING_SIZES = exports.EuiFlyout = void 0;

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _services = require("../../services");

var _common = require("../common");

var _focus_trap = require("../focus_trap");

var _overlay_mask = require("../overlay_mask");

var _button = require("../button");

var _i18n = require("../i18n");

var _resize_observer = require("../observer/resize_observer");

var _portal = require("../portal");

var _react2 = require("@emotion/react");

var _excluded = ["className", "children", "as", "hideCloseButton", "closeButtonProps", "closeButtonAriaLabel", "closeButtonPosition", "onClose", "ownFocus", "side", "size", "paddingSize", "maxWidth", "style", "maskProps", "type", "outsideClickCloses", "role", "pushMinBreakpoint", "focusTrapProps"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var typeToClassNameMap = {
  push: 'euiFlyout--push',
  overlay: null
};
var TYPES = (0, _common.keysOf)(typeToClassNameMap);
exports.TYPES = TYPES;
var sideToClassNameMap = {
  left: 'euiFlyout--left',
  right: null
};
var SIDES = (0, _common.keysOf)(sideToClassNameMap);
exports.SIDES = SIDES;
var sizeToClassNameMap = {
  s: 'euiFlyout--small',
  m: 'euiFlyout--medium',
  l: 'euiFlyout--large'
};
var SIZES = (0, _common.keysOf)(sizeToClassNameMap);
exports.SIZES = SIZES;

/**
 * Custom type checker for named flyout sizes since the prop
 * `size` can also be CSSProperties['width'] (string | number)
 */
function isEuiFlyoutSizeNamed(value) {
  return SIZES.includes(value);
}

var paddingSizeToClassNameMap = {
  none: 'euiFlyout--paddingNone',
  s: 'euiFlyout--paddingSmall',
  m: 'euiFlyout--paddingMedium',
  l: 'euiFlyout--paddingLarge'
};
var PADDING_SIZES = (0, _common.keysOf)(paddingSizeToClassNameMap);
exports.PADDING_SIZES = PADDING_SIZES;
var defaultElement = 'div';
var EuiFlyout = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var className = _ref.className,
      children = _ref.children,
      as = _ref.as,
      _ref$hideCloseButton = _ref.hideCloseButton,
      hideCloseButton = _ref$hideCloseButton === void 0 ? false : _ref$hideCloseButton,
      closeButtonProps = _ref.closeButtonProps,
      closeButtonAriaLabel = _ref.closeButtonAriaLabel,
      _ref$closeButtonPosit = _ref.closeButtonPosition,
      closeButtonPosition = _ref$closeButtonPosit === void 0 ? 'inside' : _ref$closeButtonPosit,
      onClose = _ref.onClose,
      _ref$ownFocus = _ref.ownFocus,
      ownFocus = _ref$ownFocus === void 0 ? true : _ref$ownFocus,
      _ref$side = _ref.side,
      side = _ref$side === void 0 ? 'right' : _ref$side,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'm' : _ref$size,
      _ref$paddingSize = _ref.paddingSize,
      paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
      _ref$maxWidth = _ref.maxWidth,
      maxWidth = _ref$maxWidth === void 0 ? false : _ref$maxWidth,
      style = _ref.style,
      maskProps = _ref.maskProps,
      _ref$type = _ref.type,
      type = _ref$type === void 0 ? 'overlay' : _ref$type,
      outsideClickCloses = _ref.outsideClickCloses,
      _ref$role = _ref.role,
      role = _ref$role === void 0 ? 'dialog' : _ref$role,
      _ref$pushMinBreakpoin = _ref.pushMinBreakpoint,
      pushMinBreakpoint = _ref$pushMinBreakpoin === void 0 ? 'l' : _ref$pushMinBreakpoin,
      focusTrapProps = _ref.focusTrapProps,
      rest = _objectWithoutProperties(_ref, _excluded);

  var Element = as || defaultElement;
  var maskRef = (0, _react.useRef)(null);
  var windowIsLargeEnoughToPush = (0, _services.useIsWithinMinBreakpoint)(pushMinBreakpoint);
  var isPushed = type === 'push' && windowIsLargeEnoughToPush;
  /**
   * Setting up the refs on the actual flyout element in order to
   * accommodate for the `isPushed` state by adding padding to the body equal to the width of the element
   */

  var _useState = (0, _react.useState)(null),
      _useState2 = _slicedToArray(_useState, 2),
      resizeRef = _useState2[0],
      setResizeRef = _useState2[1];

  var setRef = (0, _services.useCombinedRefs)([setResizeRef, ref]); // TODO: Allow this hook to be conditional

  var dimensions = (0, _resize_observer.useResizeObserver)(resizeRef);
  (0, _react.useEffect)(function () {
    // This class doesn't actually do anything by EUI, but is nice to add for consumers (JIC)
    document.body.classList.add('euiBody--hasFlyout');
    /**
     * Accomodate for the `isPushed` state by adding padding to the body equal to the width of the element
     */

    if (type === 'push') {
      if (isPushed) {
        if (side === 'right') {
          document.body.style.paddingRight = "".concat(dimensions.width, "px");
        } else if (side === 'left') {
          document.body.style.paddingLeft = "".concat(dimensions.width, "px");
        }
      }
    }

    return function () {
      document.body.classList.remove('euiBody--hasFlyout');

      if (type === 'push') {
        if (side === 'right') {
          document.body.style.paddingRight = '';
        } else if (side === 'left') {
          document.body.style.paddingLeft = '';
        }
      }
    };
  }, [type, side, dimensions, isPushed]);
  /**
   * ESC key closes flyout (always?)
   */

  var onKeyDown = function onKeyDown(event) {
    if (!isPushed && event.key === _services.keys.ESCAPE) {
      event.preventDefault();
      onClose(event);
    }
  };

  var newStyle;
  var widthClassName;
  var sizeClassName; // Setting max-width

  if (maxWidth === true) {
    widthClassName = 'euiFlyout--maxWidth-default';
  } else if (maxWidth !== false) {
    var value = typeof maxWidth === 'number' ? "".concat(maxWidth, "px") : maxWidth;
    newStyle = _objectSpread(_objectSpread({}, style), {}, {
      maxWidth: value
    });
  } // Setting size


  if (isEuiFlyoutSizeNamed(size)) {
    sizeClassName = sizeToClassNameMap[size];
  } else if (newStyle) {
    newStyle.width = size;
  } else {
    newStyle = _objectSpread(_objectSpread({}, style), {}, {
      width: size
    });
  }

  var classes = (0, _classnames.default)('euiFlyout', typeToClassNameMap[type], sideToClassNameMap[side], sizeClassName, paddingSizeToClassNameMap[paddingSize], widthClassName, className);
  var closeButton;

  if (onClose && !hideCloseButton) {
    var closeButtonClasses = (0, _classnames.default)('euiFlyout__closeButton', "euiFlyout__closeButton--".concat(closeButtonPosition), closeButtonProps === null || closeButtonProps === void 0 ? void 0 : closeButtonProps.className);
    closeButton = (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiFlyout.closeAriaLabel",
      default: "Close this dialog"
    }, function (closeAriaLabel) {
      return (0, _react2.jsx)(_button.EuiButtonIcon, _extends({
        display: closeButtonPosition === 'outside' ? 'fill' : 'empty',
        iconType: "cross",
        color: "text",
        "aria-label": closeButtonAriaLabel || closeAriaLabel,
        "data-test-subj": "euiFlyoutCloseButton"
      }, closeButtonProps, {
        className: closeButtonClasses,
        onClick: function onClick(e) {
          var _closeButtonProps$onC;

          onClose(e.nativeEvent);
          closeButtonProps === null || closeButtonProps === void 0 ? void 0 : (_closeButtonProps$onC = closeButtonProps.onClick) === null || _closeButtonProps$onC === void 0 ? void 0 : _closeButtonProps$onC.call(closeButtonProps, e);
        }
      }));
    });
  }

  var hasOverlayMask = ownFocus && !isPushed;

  var onClickOutside = function onClickOutside(event) {
    // Do not close the flyout for any external click
    if (outsideClickCloses === false) return undefined;

    if (hasOverlayMask) {
      // The overlay mask is present, so only clicks on the mask should close the flyout, regardless of outsideClickCloses
      if (event.target === maskRef.current) return onClose(event);
    } else {
      // No overlay mask is present, so any outside clicks should close the flyout
      if (outsideClickCloses === true) return onClose(event);
    } // Otherwise if ownFocus is false and outsideClickCloses is undefined, outside clicks should not close the flyout


    return undefined;
  };
  /*
   * Trap focus even when `ownFocus={false}`, otherwise closing
   * the flyout won't return focus to the originating button.
   *
   * Set `clickOutsideDisables={true}` when `ownFocus={false}`
   * to allow non-keyboard users the ability to interact with
   * elements outside the flyout.
   *
   * Set `onClickOutside={onClose}` when `ownFocus` and `type` are the defaults,
   * or if `outsideClickCloses={true}` to close on clicks that target
   * (both mousedown and mouseup) the overlay mask.
   */


  var flyout = (0, _react2.jsx)(_focus_trap.EuiFocusTrap, _extends({
    disabled: isPushed,
    clickOutsideDisables: !ownFocus,
    onClickOutside: onClickOutside
  }, focusTrapProps), (0, _react2.jsx)(Element, _extends({}, rest, {
    role: role,
    className: classes,
    tabIndex: -1,
    style: newStyle || style,
    ref: setRef
  }), closeButton, children)); // If ownFocus is set, wrap with an overlay and allow the user to click it to close it.

  var mergedMaskProps = _objectSpread(_objectSpread({}, maskProps), {}, {
    maskRef: (0, _services.useCombinedRefs)([maskProps === null || maskProps === void 0 ? void 0 : maskProps.maskRef, maskRef])
  });

  if (hasOverlayMask) {
    flyout = (0, _react2.jsx)(_overlay_mask.EuiOverlayMask, _extends({
      headerZindexLocation: "below"
    }, mergedMaskProps), flyout);
  } else if (!isPushed) {
    // Otherwise still wrap within an EuiPortal so it appends (unless it is the push style)
    flyout = (0, _react2.jsx)(_portal.EuiPortal, null, flyout);
  }

  return (0, _react2.jsx)(_react.Fragment, null, (0, _react2.jsx)(_services.EuiWindowEvent, {
    event: "keydown",
    handler: onKeyDown
  }), flyout);
} // React.forwardRef interferes with the inferred element type
// Casting to ensure correct element prop type checking for `as`
// e.g., `href` is not on a `div`
); // Recast to allow `displayName`

exports.EuiFlyout = EuiFlyout;
EuiFlyout.displayName = 'EuiFlyout';