"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiImageButton = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _services = require("../../services");

var _i18n = require("../i18n");

var _icon = require("../icon");

var _accessibility = require("../accessibility");

var _image_button = require("./image_button.styles");

var _react2 = require("@emotion/react");

var _excluded = ["hasAlt", "hasShadow", "children", "onClick", "onKeyDown", "isFullScreen", "isFullWidth", "fullScreenIconColor"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var fullScreenIconColorMap = {
  light: 'ghost',
  dark: 'default'
};

var EuiImageButton = function EuiImageButton(_ref) {
  var hasAlt = _ref.hasAlt,
      hasShadow = _ref.hasShadow,
      children = _ref.children,
      onClick = _ref.onClick,
      onKeyDown = _ref.onKeyDown,
      isFullScreen = _ref.isFullScreen,
      isFullWidth = _ref.isFullWidth,
      _ref$fullScreenIconCo = _ref.fullScreenIconColor,
      fullScreenIconColor = _ref$fullScreenIconCo === void 0 ? 'light' : _ref$fullScreenIconCo,
      rest = _objectWithoutProperties(_ref, _excluded);

  var euiTheme = (0, _services.useEuiTheme)();
  var buttonStyles = (0, _image_button.euiImageButtonStyles)(euiTheme);
  var cssButtonStyles = [buttonStyles.euiImageButton, hasShadow ? buttonStyles.hasShadowHover : buttonStyles.shadowHover, !isFullScreen && isFullWidth && buttonStyles.fullWidth];
  var iconStyles = (0, _image_button.euiImageButtonIconStyles)(euiTheme);
  var cssIconStyles = [iconStyles.euiImageButton__icon, iconStyles.openFullScreen];
  var openFullScreenInstructions = (0, _i18n.useEuiI18n)('euiImageButton.openFullScreen', 'Click to open this image in fullscreen mode');
  var closeFullScreenInstructions = (0, _i18n.useEuiI18n)('euiImageButton.closeFullScreen', 'Press Escape or click to close image fullscreen mode');
  var iconColor = fullScreenIconColorMap[fullScreenIconColor];
  return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)("button", _extends({
    type: "button",
    css: cssButtonStyles,
    onClick: onClick,
    onKeyDown: onKeyDown
  }, rest), isFullScreen && // In fullscreen mode, instructions should come first to allow screen reader
  // users to quickly exit vs. potentially reading out long/unskippable alt text
  (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", null, closeFullScreenInstructions, hasAlt && ' — ')), children, !isFullScreen && (0, _react2.jsx)("div", {
    css: cssIconStyles
  }, (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", null, hasAlt && ' — ', openFullScreenInstructions)), (0, _react2.jsx)(_icon.EuiIcon, {
    type: "fullScreen",
    color: iconColor
  }))));
};

exports.EuiImageButton = EuiImageButton;
EuiImageButton.propTypes = {
  hasAlt: _propTypes.default.bool.isRequired,
  onClick: _propTypes.default.func.isRequired,
  onKeyDown: _propTypes.default.func,
  isFullWidth: _propTypes.default.bool.isRequired,
  isFullScreen: _propTypes.default.bool
};