"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiImageWrapper = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _services = require("../../services");

var _inner_text = require("../inner_text");

var _image_wrapper = require("./image_wrapper.styles");

var _image_button = require("./image_button");

var _image_caption = require("./image_caption");

var _react2 = require("@emotion/react");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var EuiImageWrapper = function EuiImageWrapper(_ref) {
  var alt = _ref.alt,
      caption = _ref.caption,
      hasShadow = _ref.hasShadow,
      allowFullScreen = _ref.allowFullScreen,
      float = _ref.float,
      margin = _ref.margin,
      children = _ref.children,
      setIsFullScreen = _ref.setIsFullScreen,
      wrapperProps = _ref.wrapperProps,
      fullScreenIconColor = _ref.fullScreenIconColor,
      isFullWidth = _ref.isFullWidth;

  var openFullScreen = function openFullScreen() {
    setIsFullScreen(true);
  };

  var classes = (0, _classnames.default)('euiImageWrapper', wrapperProps && wrapperProps.className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _image_wrapper.euiImageWrapperStyles)(euiTheme);
  var cssFigureStyles = [styles.euiImageWrapper, float && styles[float], margin && styles[margin], allowFullScreen && styles.allowFullScreen, isFullWidth && styles.fullWidth];

  var _useInnerText = (0, _inner_text.useInnerText)(),
      _useInnerText2 = _slicedToArray(_useInnerText, 2),
      optionalCaptionRef = _useInnerText2[0],
      optionalCaptionText = _useInnerText2[1];

  return (0, _react2.jsx)("figure", _extends({
    "aria-label": optionalCaptionText,
    css: cssFigureStyles
  }, wrapperProps, {
    className: classes
  }), allowFullScreen ? (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_image_button.EuiImageButton, {
    hasAlt: !!alt,
    hasShadow: hasShadow,
    onClick: openFullScreen,
    "data-test-subj": "activateFullScreenButton",
    isFullWidth: isFullWidth,
    fullScreenIconColor: fullScreenIconColor
  }, children)) : children, (0, _react2.jsx)(_image_caption.EuiImageCaption, {
    ref: optionalCaptionRef,
    caption: caption
  }));
};

exports.EuiImageWrapper = EuiImageWrapper;
EuiImageWrapper.propTypes = {
  isFullWidth: _propTypes.default.bool.isRequired,
  setIsFullScreen: _propTypes.default.func.isRequired
};