"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiKeyPadMenuItem = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _beta_badge = require("../badge/beta_badge");

var _services = require("../../services");

var _form = require("../form");

var _href_validator = require("../../services/security/href_validator");

var _tool_tip = require("../tool_tip");

var _react2 = require("@emotion/react");

var _excluded = ["id", "isSelected", "isDisabled", "label", "children", "className", "betaBadgeLabel", "betaBadgeTooltipContent", "betaBadgeIconType", "betaBadgeTooltipProps", "href", "rel", "target", "buttonRef", "checkable", "name", "value", "disabled", "onChange"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var EuiKeyPadMenuItem = function EuiKeyPadMenuItem(_ref) {
  var id = _ref.id,
      isSelected = _ref.isSelected,
      _isDisabled = _ref.isDisabled,
      label = _ref.label,
      children = _ref.children,
      className = _ref.className,
      betaBadgeLabel = _ref.betaBadgeLabel,
      betaBadgeTooltipContent = _ref.betaBadgeTooltipContent,
      betaBadgeIconType = _ref.betaBadgeIconType,
      betaBadgeTooltipProps = _ref.betaBadgeTooltipProps,
      href = _ref.href,
      rel = _ref.rel,
      target = _ref.target,
      buttonRef = _ref.buttonRef,
      checkable = _ref.checkable,
      name = _ref.name,
      value = _ref.value,
      disabled = _ref.disabled,
      _onChange = _ref.onChange,
      rest = _objectWithoutProperties(_ref, _excluded);

  var isHrefValid = !href || (0, _href_validator.validateHref)(href);
  var isDisabled = disabled || _isDisabled || !isHrefValid;
  var classes = (0, _classnames.default)('euiKeyPadMenuItem', {
    'euiKeyPadMenuItem--hasBetaBadge': betaBadgeLabel,
    'euiKeyPadMenuItem--checkable': checkable,
    'euiKeyPadMenuItem-isDisabled': isDisabled,
    'euiKeyPadMenuItem-isSelected': isSelected
  }, className);
  var Element = href && !isDisabled ? 'a' : 'button';
  if (checkable) Element = 'label';
  var itemId = (0, _services.useGeneratedHtmlId)({
    conditionalId: id
  });

  var renderCheckableElement = function renderCheckableElement() {
    if (!checkable) return;
    var inputClasses = (0, _classnames.default)('euiKeyPadMenuItem__checkableInput');
    var checkableElement;

    if (checkable === 'single') {
      checkableElement = (0, _react2.jsx)(_form.EuiRadio, {
        id: itemId,
        className: inputClasses,
        checked: isSelected,
        disabled: isDisabled,
        name: name,
        value: value,
        onChange: function onChange() {
          return _onChange(itemId, value);
        }
      });
    } else {
      checkableElement = (0, _react2.jsx)(_form.EuiCheckbox, {
        id: itemId,
        className: inputClasses,
        checked: isSelected,
        disabled: isDisabled,
        name: name,
        onChange: function onChange() {
          return _onChange(itemId);
        }
      });
    }

    return checkableElement;
  };

  var renderBetaBadge = function renderBetaBadge() {
    if (!betaBadgeLabel) return;
    return (0, _react2.jsx)(_beta_badge.EuiBetaBadge // Since we move the tooltip contents to a wrapping EuiToolTip,
    // this badge is purely visual therefore we can safely hide it from screen readers
    , {
      "aria-hidden": "true",
      size: "s",
      color: "subdued",
      className: "euiKeyPadMenuItem__betaBadge",
      label: betaBadgeLabel.charAt(0),
      iconType: betaBadgeIconType
    });
  };

  var relObj = {};

  if (href && !isDisabled) {
    relObj.href = href;
    relObj.rel = (0, _services.getSecureRelForTarget)({
      href: href,
      target: target,
      rel: rel
    });
    relObj.target = target;
    relObj['aria-current'] = isSelected ? isSelected : undefined;
  } else if (checkable) {
    relObj.htmlFor = itemId;
  } else {
    relObj.disabled = isDisabled;
    relObj.type = 'button';
    relObj['aria-pressed'] = isSelected;
  }

  var button = (0, _react2.jsx)(Element, _extends({
    className: classes
  }, relObj, rest, {
    // Unable to get past `LegacyRef` conflicts
    ref: buttonRef
  }), (0, _react2.jsx)("span", {
    className: "euiKeyPadMenuItem__inner"
  }, checkable ? renderCheckableElement() : renderBetaBadge(), (0, _react2.jsx)("span", {
    className: "euiKeyPadMenuItem__icon"
  }, children), (0, _react2.jsx)("span", {
    className: "euiKeyPadMenuItem__label"
  }, label)));
  return betaBadgeLabel ? (0, _react2.jsx)(_tool_tip.EuiToolTip, _extends({}, betaBadgeTooltipProps, {
    title: betaBadgeLabel,
    content: betaBadgeTooltipContent,
    delay: "long"
  }), button) : button;
};

exports.EuiKeyPadMenuItem = EuiKeyPadMenuItem;
EuiKeyPadMenuItem.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,

  /**
     * One will be generated if not provided
     */

  /**
     * One will be generated if not provided
     */

  /**
     * One will be generated if not provided
     */
  id: _propTypes.default.string,

  /**
     * Pass an EuiIcon, preferrably `size="l"`
     */

  /**
     * Pass an EuiIcon, preferrably `size="l"`
     */

  /**
     * Pass an EuiIcon, preferrably `size="l"`
     */
  children: _propTypes.default.node.isRequired,
  isDisabled: _propTypes.default.bool,

  /**
     * Indicate if an item is the current one.
     * Be sure to use `true` AND `false` when acting as a toggle to ensure the attribute is added for both states
     */

  /**
     * Indicate if an item is the current one.
     * Be sure to use `true` AND `false` when acting as a toggle to ensure the attribute is added for both states
     */

  /**
     * Indicate if an item is the current one.
     * Be sure to use `true` AND `false` when acting as a toggle to ensure the attribute is added for both states
     */
  isSelected: _propTypes.default.bool,

  /**
     * The text to display beneath the icon
     */

  /**
     * The text to display beneath the icon
     */

  /**
     * The text to display beneath the icon
     */
  label: _propTypes.default.node.isRequired,

  /**
     * Beta badges are unavailable if the item is checkable
     */

  /**
     * Beta badges are unavailable if the item is checkable
     */

  /**
         * Type `'multi'` renders the item as a `<label>` and
         * adds a checkbox.
         */

  /**
         * Type `'single'` renders the item as a `<label>` and
         * adds a radio element.
         */
  checkable: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.oneOf(["single"]).isRequired, _propTypes.default.oneOf(["multi"]).isRequired]).isRequired, _propTypes.default.oneOf([undefined])]),

  /**
         * The `name` attribute for radio inputs;
         * Required in order to group properly
         */
  name: _propTypes.default.string,

  /**
         * The value of the radio input for 'single'
         */
  value: _propTypes.default.string,

  /**
         * Multi: Returns the `id` of the clicked option
         */

  /**
         * Single: Returns the `id` of the clicked option and the `value`
         */
  onChange: _propTypes.default.func,
  href: _propTypes.default.string,
  onClick: _propTypes.default.func,
  buttonRef: _propTypes.default.any,
  rel: _propTypes.default.string,

  /**
     * Add a badge to the card to label it as "Beta" or other non-GA state
     */

  /**
     * Add a badge to the card to label it as "Beta" or other non-GA state
     */
  betaBadgeLabel: _propTypes.default.string,

  /**
     * Supply an icon type if the badge should just be an icon
     */
  betaBadgeIconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "alert", "analyzeEvent", "annotation", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "check", "checkInCircleFilled", "cheer", "classificationJob", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "codeApp", "color", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crossInACircleFilled", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "discoverApp", "document", "documentEdit", "documentation", "documents", "dot", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "eql", "eraser", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "mobile", "monitoringApp", "moon", "namespace", "nested", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipelineApp", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "snowflake", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelionApp", "timeRefresh", "timeslider", "training", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDenseVector", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),

  /**
     * Add a description to the beta badge (will appear in a tooltip)
     */

  /**
     * Add a description to the beta badge (will appear in a tooltip)
     */
  betaBadgeTooltipContent: _propTypes.default.node,

  /**
     * Extends the wrapping EuiToolTip props when `betaBadgeLabel` is provided
     */

  /**
     * Extends the wrapping EuiToolTip props when `betaBadgeLabel` is provided
     */
  betaBadgeTooltipProps: _propTypes.default.any
};