"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.EuiLoadingSpinner = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _services = require("../..//services");

var _loading_strings = require("./_loading_strings");

var _loading_spinner = require("./loading_spinner.styles");

var _react2 = require("@emotion/react");

var _excluded = ["size", "className", "aria-label", "color"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var SIZES = ['s', 'm', 'l', 'xl', 'xxl'];
exports.SIZES = SIZES;

var EuiLoadingSpinner = function EuiLoadingSpinner(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'm' : _ref$size,
      className = _ref.className,
      ariaLabel = _ref['aria-label'],
      color = _ref.color,
      rest = _objectWithoutProperties(_ref, _excluded);

  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _loading_spinner.euiLoadingSpinnerStyles)(euiTheme, color);
  var cssStyles = [styles.euiLoadingSpinner, styles[size]];
  var classes = (0, _classnames.default)('euiLoadingSpinner', className);
  var defaultLabel = (0, _loading_strings.useLoadingAriaLabel)();
  return (0, _react2.jsx)("span", _extends({
    className: classes,
    css: cssStyles,
    role: "progressbar",
    "aria-label": ariaLabel || defaultLabel
  }, rest));
};

exports.EuiLoadingSpinner = EuiLoadingSpinner;
EuiLoadingSpinner.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  size: _propTypes.default.any,

  /**
       * Sets the color of the border and highlight.
       * Each key accepts any valid CSS color value as a `string`
       * See #EuiLoadingSpinnerColor
       */
  color: _propTypes.default.shape({
    border: _propTypes.default.any,
    highlight: _propTypes.default.any
  })
};