"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PAGE_MAX_WIDTH = void 0;
exports.setPropsForRestrictedPageWidth = setPropsForRestrictedPageWidth;
exports.setStyleForRestrictedPageWidth = setStyleForRestrictedPageWidth;

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * The `restrictedWidth` property is the same for all EuiPage components.
 * This is file contains the type specific to that prop and a helper
 * function for creating the corresponding classNames and style tags
 * based on the consumer's configuration
 */
// TODO: Decide how to make this a global value but still isolated to the page component
var PAGE_MAX_WIDTH = '1200px';
exports.PAGE_MAX_WIDTH = PAGE_MAX_WIDTH;

/**
 * **DEPRECATED**
 * This function calculates the correct class name and combined styles
 * based on the `restrictWidth` value passed in
 *
 * @param restrictWidth `boolean | number | string` The prop value
 * @param style `CSSProperties` An object of style attributes if provided
 * @returns An object with keys for the `widthClassName` to append to the component's class and the updated `newStyle` props
 */
function setPropsForRestrictedPageWidth(restrictWidth, style) {
  var widthClassName;

  var newStyle = _objectSpread({}, style);

  if (restrictWidth === true) {
    widthClassName = 'restrictWidth-default';
  } else if (restrictWidth !== false) {
    widthClassName = 'restrictWidth-custom';
    newStyle.maxWidth = restrictWidth;
  }

  return {
    widthClassName: widthClassName,
    newStyle: newStyle
  };
}
/**
 * This function calculates the correct just the combined styles
 * based on the `restrictWidth` value passed in
 *
 * @param restrictWidth `boolean | number | string` The prop value
 * @param style `CSSProperties` An object of style attributes if provided
 * @returns An object of the updated `style` props
 */


function setStyleForRestrictedPageWidth(restrictWidth, style) {
  var newStyle = _objectSpread({}, style);

  if (restrictWidth === true) {
    newStyle.maxWidth = PAGE_MAX_WIDTH;
  } else if (restrictWidth !== false) {
    newStyle.maxWidth = restrictWidth;
  }

  return newStyle;
}