"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TEMPLATES = exports.EuiPageTemplate_Deprecated = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _react2 = require("@emotion/react");

var _page = require("./page");

var _page_side_bar = require("./page_side_bar");

var _page_body = require("./page_body");

var _page_header = require("./page_header");

var _page_content = require("./page_content");

var _bottom_bar = require("../bottom_bar");

var _services = require("../../services");

var _flex = require("../flex");

var _global_styling = require("../../global_styling");

var _excluded = ["template", "restrictWidth", "grow", "paddingSize", "fullHeight", "children", "className", "pageSideBar", "pageSideBarProps", "pageHeader", "pageBodyProps", "pageContentProps", "pageContentBodyProps", "bottomBar", "bottomBarProps", "minHeight"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var TEMPLATES = ['default', 'centeredBody', 'centeredContent', 'empty'];
exports.TEMPLATES = TEMPLATES;

/**
 * This component has been deprecated in favor of the new
 * namespaced version. You can still import this component
 * until August 2023 by importing `as EuiPageTemplate`.
 *
 * @deprecated use EuiPageTemplate from page_template/page_template instead
 */
var EuiPageTemplate_Deprecated = function EuiPageTemplate_Deprecated(_ref) {
  var _pageBodyProps2;

  var _ref$template = _ref.template,
      template = _ref$template === void 0 ? 'default' : _ref$template,
      _ref$restrictWidth = _ref.restrictWidth,
      restrictWidth = _ref$restrictWidth === void 0 ? true : _ref$restrictWidth,
      _ref$grow = _ref.grow,
      grow = _ref$grow === void 0 ? true : _ref$grow,
      _ref$paddingSize = _ref.paddingSize,
      paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
      fullHeight = _ref.fullHeight,
      children = _ref.children,
      className = _ref.className,
      pageSideBar = _ref.pageSideBar,
      pageSideBarProps = _ref.pageSideBarProps,
      pageHeader = _ref.pageHeader,
      pageBodyProps = _ref.pageBodyProps,
      pageContentProps = _ref.pageContentProps,
      pageContentBodyProps = _ref.pageContentBodyProps,
      bottomBar = _ref.bottomBar,
      bottomBarProps = _ref.bottomBarProps,
      _ref$minHeight = _ref.minHeight,
      minHeight = _ref$minHeight === void 0 ? 460 : _ref$minHeight,
      rest = _objectWithoutProperties(_ref, _excluded);

  // BWC page header margin to match padding
  var headerMargin = /*#__PURE__*/(0, _react2.css)("margin-bottom: ".concat((0, _global_styling.useEuiPaddingSize)(paddingSize)), ";label:headerMargin;");
  /**
   * Full height ~madness~ logic
   */

  var canFullHeight = (0, _services.useIsWithinBreakpoints)(['m', 'l', 'xl']) && (template === 'default' || template === 'empty');
  var fullHeightClass = {
    'eui-fullHeight': fullHeight && canFullHeight
  };
  var yScrollClass = {
    'eui-yScroll': fullHeight && canFullHeight
  };

  if (canFullHeight && fullHeight) {
    var _pageBodyProps, _pageContentProps, _pageContentBodyProps;

    // By using flex group it will also fix the negative margin issues for nested flex groups
    children = (0, _react2.jsx)(_flex.EuiFlexGroup, {
      className: "eui-fullHeight",
      gutterSize: "none",
      direction: "column",
      responsive: false
    }, (0, _react2.jsx)(_flex.EuiFlexItem, {
      className: (0, _classnames.default)({
        'eui-yScroll': fullHeight === true,
        'eui-fullHeight': fullHeight === 'noscroll'
      }),
      grow: true
    }, children));
    pageBodyProps = _objectSpread(_objectSpread({}, pageBodyProps), {}, {
      className: (0, _classnames.default)(fullHeightClass, (_pageBodyProps = pageBodyProps) === null || _pageBodyProps === void 0 ? void 0 : _pageBodyProps.className)
    });
    pageContentProps = _objectSpread(_objectSpread({}, pageContentProps), {}, {
      className: (0, _classnames.default)(yScrollClass, (_pageContentProps = pageContentProps) === null || _pageContentProps === void 0 ? void 0 : _pageContentProps.className)
    });
    pageContentBodyProps = _objectSpread(_objectSpread({}, pageContentBodyProps), {}, {
      className: (0, _classnames.default)(fullHeightClass, (_pageContentBodyProps = pageContentBodyProps) === null || _pageContentBodyProps === void 0 ? void 0 : _pageContentBodyProps.className)
    });
  }

  var classes = (0, _classnames.default)('euiPageTemplate', fullHeightClass, className);

  var pageStyle = _objectSpread({
    minHeight: minHeight
  }, rest.style);
  /**
   * This seems very repetitious but it's the most readable, scalable, and maintainable
   */


  switch (template) {
    /**
     * CENTERED BODY
     * The panelled content is centered
     */
    case 'centeredBody':
      return pageSideBar ? (0, _react2.jsx)(_page.EuiPage, _extends({
        className: classes,
        paddingSize: "none",
        grow: grow
      }, rest, {
        style: pageStyle
      }), (0, _react2.jsx)(_page_side_bar.EuiPageSideBar_Deprecated, _extends({
        sticky: true,
        paddingSize: paddingSize
      }, pageSideBarProps), pageSideBar), (0, _react2.jsx)(_page_body.EuiPageBody, _extends({
        paddingSize: paddingSize
      }, pageBodyProps), pageHeader && (0, _react2.jsx)(_page_header.EuiPageHeader, _extends({
        restrictWidth: restrictWidth,
        css: headerMargin
      }, pageHeader)), (0, _react2.jsx)(_page_content.EuiPageContent_Deprecated, _extends({
        verticalPosition: "center",
        horizontalPosition: "center",
        paddingSize: paddingSize
      }, pageContentProps), (0, _react2.jsx)(_page_content.EuiPageContentBody_Deprecated, _extends({
        restrictWidth: restrictWidth
      }, pageContentBodyProps), children)))) : (0, _react2.jsx)(_page.EuiPage, _extends({
        className: classes,
        paddingSize: paddingSize,
        grow: grow
      }, rest, {
        style: pageStyle
      }), (0, _react2.jsx)(_page_body.EuiPageBody, _extends({
        restrictWidth: restrictWidth
      }, pageBodyProps), pageHeader && (0, _react2.jsx)(_page_header.EuiPageHeader, _extends({
        paddingSize: "none",
        restrictWidth: false,
        css: headerMargin,
        bottomBorder: true
      }, pageHeader)), (0, _react2.jsx)(_page_body.EuiPageBody, null, (0, _react2.jsx)(_page_content.EuiPageContent_Deprecated, _extends({
        verticalPosition: "center",
        horizontalPosition: "center",
        paddingSize: paddingSize
      }, pageContentProps), (0, _react2.jsx)(_page_content.EuiPageContentBody_Deprecated, _extends({
        paddingSize: "none",
        restrictWidth: restrictWidth
      }, pageContentBodyProps), children)))));

    /**
     * CENTERED CONTENT
     * The content inside the panel is centered
     */

    case 'centeredContent':
      return pageSideBar ? (0, _react2.jsx)(_page.EuiPage, _extends({
        className: classes,
        paddingSize: "none",
        grow: grow
      }, rest, {
        style: pageStyle
      }), (0, _react2.jsx)(_page_side_bar.EuiPageSideBar_Deprecated, _extends({
        sticky: true,
        paddingSize: paddingSize
      }, pageSideBarProps), pageSideBar), (0, _react2.jsx)(_page_body.EuiPageBody, _extends({
        panelled: true,
        paddingSize: paddingSize
      }, pageBodyProps), pageHeader && (0, _react2.jsx)(_page_header.EuiPageHeader, _extends({
        restrictWidth: restrictWidth,
        css: headerMargin
      }, pageHeader)), (0, _react2.jsx)(_page_content.EuiPageContent_Deprecated, _extends({
        verticalPosition: "center",
        horizontalPosition: "center",
        hasShadow: false,
        color: "subdued",
        paddingSize: paddingSize
      }, pageContentProps), (0, _react2.jsx)(_page_content.EuiPageContentBody_Deprecated, _extends({
        restrictWidth: restrictWidth
      }, pageContentBodyProps), children)))) : (0, _react2.jsx)(_page.EuiPage, _extends({
        className: classes,
        paddingSize: "none",
        grow: grow
      }, rest, {
        style: pageStyle
      }), (0, _react2.jsx)(_page_body.EuiPageBody, pageBodyProps, pageHeader && (0, _react2.jsx)(_page_header.EuiPageHeader, _extends({
        paddingSize: paddingSize,
        restrictWidth: restrictWidth,
        bottomBorder: "extended"
      }, pageHeader)), (0, _react2.jsx)(_page_content.EuiPageContent_Deprecated, {
        role: null,
        borderRadius: "none",
        hasShadow: false,
        paddingSize: paddingSize,
        style: {
          display: 'flex'
        }
      }, (0, _react2.jsx)(_page_content.EuiPageContent_Deprecated, _extends({
        verticalPosition: "center",
        horizontalPosition: "center",
        hasShadow: false,
        color: "subdued",
        paddingSize: paddingSize
      }, pageContentProps), (0, _react2.jsx)(_page_content.EuiPageContentBody_Deprecated, _extends({
        restrictWidth: restrictWidth
      }, pageContentBodyProps), children)))));

    /**
     * EMPTY
     * No panelling at all
     */

    case 'empty':
      return pageSideBar ? (0, _react2.jsx)(_page.EuiPage, _extends({
        className: classes,
        paddingSize: "none",
        grow: grow
      }, rest, {
        style: pageStyle
      }), (0, _react2.jsx)(_page_side_bar.EuiPageSideBar_Deprecated, _extends({
        sticky: true,
        paddingSize: paddingSize
      }, pageSideBarProps), pageSideBar), (0, _react2.jsx)(_page_body.EuiPageBody, _extends({
        paddingSize: paddingSize
      }, pageBodyProps), pageHeader && (0, _react2.jsx)(_page_header.EuiPageHeader, _extends({
        restrictWidth: restrictWidth,
        bottomBorder: true,
        css: headerMargin
      }, pageHeader)), (0, _react2.jsx)(_page_content.EuiPageContent_Deprecated, _extends({
        hasBorder: false,
        hasShadow: false,
        paddingSize: 'none',
        color: 'transparent',
        borderRadius: 'none'
      }, pageContentProps), (0, _react2.jsx)(_page_content.EuiPageContentBody_Deprecated, _extends({
        restrictWidth: restrictWidth
      }, pageContentBodyProps), children)))) : (0, _react2.jsx)(_page.EuiPage, _extends({
        className: classes,
        paddingSize: paddingSize,
        grow: grow
      }, rest, {
        style: pageStyle
      }), (0, _react2.jsx)(_page_body.EuiPageBody, _extends({
        restrictWidth: restrictWidth
      }, pageBodyProps), pageHeader && (0, _react2.jsx)(_page_header.EuiPageHeader, _extends({
        paddingSize: "none",
        restrictWidth: false,
        css: headerMargin,
        bottomBorder: true
      }, pageHeader)), (0, _react2.jsx)(_page_content.EuiPageContent_Deprecated, _extends({
        hasBorder: false,
        hasShadow: false,
        paddingSize: 'none',
        color: 'transparent',
        borderRadius: 'none'
      }, pageContentProps), (0, _react2.jsx)(_page_content.EuiPageContentBody_Deprecated, _extends({
        paddingSize: "none"
      }, pageContentBodyProps), children))));

    /**
     * DEFAULT
     * Typical layout with nothing "centered"
     */

    default:
      // Only the default template can display a bottom bar
      var bottomBarNode = bottomBar ? (0, _react2.jsx)(_bottom_bar.EuiBottomBar, _extends({
        paddingSize: paddingSize,
        position: canFullHeight && fullHeight ? 'static' : 'sticky' // Using uknown here because of the possible conflict with overriding props and position `sticky`

      }, bottomBarProps), (0, _react2.jsx)(_page_content.EuiPageContentBody_Deprecated, {
        paddingSize: 'none',
        restrictWidth: restrictWidth
      }, bottomBar)) : undefined;
      return pageSideBar ? (0, _react2.jsx)(_page.EuiPage, _extends({
        className: classes,
        paddingSize: "none",
        grow: grow
      }, rest, {
        style: pageStyle
      }), (0, _react2.jsx)(_page_side_bar.EuiPageSideBar_Deprecated, _extends({
        sticky: true,
        paddingSize: paddingSize
      }, pageSideBarProps), pageSideBar), (0, _react2.jsx)(_page_body.EuiPageBody, _extends({
        panelled: true,
        paddingSize: "none"
      }, pageBodyProps), (0, _react2.jsx)(_page_body.EuiPageBody, {
        component: "div",
        paddingSize: paddingSize,
        className: (_pageBodyProps2 = pageBodyProps) === null || _pageBodyProps2 === void 0 ? void 0 : _pageBodyProps2.className
      }, pageHeader && (0, _react2.jsx)(_page_header.EuiPageHeader, _extends({
        bottomBorder: true,
        restrictWidth: restrictWidth,
        css: headerMargin
      }, pageHeader)), (0, _react2.jsx)(_page_content.EuiPageContent_Deprecated, _extends({
        hasShadow: false,
        hasBorder: false,
        color: 'transparent',
        borderRadius: 'none',
        paddingSize: "none"
      }, pageContentProps), (0, _react2.jsx)(_page_content.EuiPageContentBody_Deprecated, _extends({
        restrictWidth: restrictWidth
      }, pageContentBodyProps), children))), bottomBarNode)) : (0, _react2.jsx)(_page.EuiPage, _extends({
        className: classes,
        paddingSize: "none",
        grow: grow
      }, rest, {
        style: pageStyle
      }), (0, _react2.jsx)(_page_body.EuiPageBody, pageBodyProps, pageHeader && (0, _react2.jsx)(_page_header.EuiPageHeader, _extends({
        restrictWidth: restrictWidth,
        paddingSize: paddingSize,
        bottomBorder: "extended"
      }, pageHeader)), (0, _react2.jsx)(_page_content.EuiPageContent_Deprecated, _extends({
        hasBorder: pageHeader === undefined ? false : undefined,
        hasShadow: false,
        paddingSize: 'none',
        color: 'plain',
        borderRadius: 'none'
      }, pageContentProps), (0, _react2.jsx)(_page_content.EuiPageContentBody_Deprecated, _extends({
        restrictWidth: restrictWidth,
        paddingSize: paddingSize
      }, pageContentBodyProps), children)), bottomBarNode));
  }
};

exports.EuiPageTemplate_Deprecated = EuiPageTemplate_Deprecated;
EuiPageTemplate_Deprecated.propTypes = {
  /**
     * Choose between 3 types of templates.
     * `default`: Typical layout with nothing centered
     * `centeredBody`: The panelled content is centered
     * `centeredContent`: The content inside the panel is centered
     * `empty`: Removes the panneling of the page content
     */
  template: _propTypes.default.any,

  /**
     * Padding size will not get applied to the over-arching #EuiPage,
     * but will propogate through all the components to keep them in sync
     */
  paddingSize: _propTypes.default.oneOf(["none", "s", "m", "l"]),

  /**
     * Optionally include #EuiPageSideBar content.
     * The inclusion of this will affect the whole layout
     */
  pageSideBar: _propTypes.default.node,

  /**
     * Gets passed along to the #EuiPageSideBar component
     */
  pageSideBarProps: _propTypes.default.shape({
    /**
       * Adds `position: sticky`
       */
    sticky: _propTypes.default.bool,

    /**
       * Adds padding around the children
       */
    paddingSize: _propTypes.default.any,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }),

  /**
     * Optionally include an #EuiPageHeader by passing an object of its props
     */
  pageHeader: _propTypes.default.shape({
    /**
       * Adjust the overall padding.
       */
    paddingSize: _propTypes.default.any,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,

    /**
       * Sets the max-width of the page,
       * set to `true` to use the default size of `1200px`,
       * set to `false` to not restrict the width,
       * set to a number for a custom width in px,
       * set to a string for a custom width in custom measurement.
       */
    restrictWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),

    /**
       * Adds a bottom border to separate it from the content after;
       * Passing `extended` will ensure the border touches the sides of the parent container.
       */
    bottomBorder: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["extended"])])
  }),

  /**
     * Gets passed along to the #EuiPageBody component
     */
  pageBodyProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,

    /**
       * Sets the max-width of the page,
       * set to `true` to use the default size of `1200px`,
       * set to `false` to not restrict the width,
       * set to a number for a custom width in px,
       * set to a string for a custom width in custom measurement.
       */
    restrictWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),

    /**
         * Sets the HTML element for `EuiPageBody`.
         */
    component: _propTypes.default.any,

    /**
         * Uses an EuiPanel as the main component instead of a plain div
         */
    panelled: _propTypes.default.bool,

    /**
         * Extends any extra EuiPanel props if `panelled=true`
         */
    panelProps: _propTypes.default.any,

    /**
         * Adjusts the padding
         */
    paddingSize: _propTypes.default.any
  }),

  /**
     * Gets passed along to the #EuiPageContent component
     */
  pageContentProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,

    /**
       * Adds a medium shadow to the panel;
       * Only works when `color="plain"`
       */

    /**
       * Adds a medium shadow to the panel;
       * Only works when `color="plain"`
       */
    hasShadow: _propTypes.default.bool,

    /**
       * Adds a slight 1px border on all edges.
       * Only works when `color="plain | transparent"`
       */

    /**
       * Adds a slight 1px border on all edges.
       * Only works when `color="plain | transparent"`
       */
    hasBorder: _propTypes.default.bool,

    /**
       * Padding for all four sides
       */

    /**
       * Padding for all four sides
       */
    paddingSize: _propTypes.default.any,

    /**
       * Corner border radius
       */

    /**
       * Corner border radius
       */
    borderRadius: _propTypes.default.any,

    /**
       * When true the panel will grow in height to match `EuiFlexItem`
       */

    /**
       * When true the panel will grow in height to match `EuiFlexItem`
       */
    grow: _propTypes.default.bool,
    panelRef: _propTypes.default.any,

    /**
       * Background color of the panel;
       * Usually a lightened form of the brand colors
       */

    /**
       * Background color of the panel;
       * Usually a lightened form of the brand colors
       */
    color: _propTypes.default.any,
    element: _propTypes.default.oneOf(["div"]),
    verticalPosition: _propTypes.default.oneOf(["center"]),
    horizontalPosition: _propTypes.default.oneOf(["center"]),

    /**
         * There should only be one EuiPageContent per page and should contain the main contents.
         * If this is untrue, set role = `null`, or change it to match your needed aria role
         */
    role: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.oneOf([null])])
  }),

  /**
     * Gets passed along to the #EuiPageContentBody component
     */
  pageContentBodyProps: _propTypes.default.shape({
    /**
       * Adjust the padding.
       * When using this setting it's best to be consistent throughout all similar usages
       */
    paddingSize: _propTypes.default.any,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,

    /**
       * Sets the max-width of the page,
       * set to `true` to use the default size of `1200px`,
       * set to `false` to not restrict the width,
       * set to a number for a custom width in px,
       * set to a string for a custom width in custom measurement.
       */
    restrictWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired])
  }),

  /**
     * Adds contents inside of an EuiBottomBar.
     * Only works when `template = 'default'`
     */
  bottomBar: _propTypes.default.any,

  /**
     * Gets passed along to the #EuiBottomBar component if `bottomBar` has contents
     */
  bottomBarProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,

    /**
         * How to position the bottom bar against its parent.
         */
    position: _propTypes.default.oneOfType([_propTypes.default.oneOf(["fixed"]), _propTypes.default.oneOf(["static", "sticky"]).isRequired]),

    /**
         * Whether to wrap in an EuiPortal which appends the component to the body element.
         * Only works if `position` is `fixed`.
         */
    usePortal: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.shape({
      /**
         * ReactNode to render as this component's content
         */
      children: _propTypes.default.node.isRequired,
      insert: _propTypes.default.shape({
        sibling: _propTypes.default.any.isRequired,
        position: _propTypes.default.oneOf(["before", "after"]).isRequired
      }),
      portalRef: _propTypes.default.func
    }).isRequired]),

    /**
         * Whether the component should apply padding on the document body element to afford for its own displacement height.
         * Only works if `usePortal` is true and `position` is `fixed`.
         */
    affordForDisplacement: _propTypes.default.bool,

    /**
         * Padding applied to the bar. Default is 'm'.
         */
    paddingSize: _propTypes.default.oneOf(["none", "s", "m", "l"]),

    /**
         * Optional class applied to the body element on mount.
         */
    bodyClassName: _propTypes.default.string,

    /**
         * Customize the screen reader heading that helps users find this control. Default is 'Page level controls'.
         */
    landmarkHeading: _propTypes.default.string,

    /**
         * Starting vertical position when `fixed` position.
         * Offset from the top of the window when `sticky` position.
         * Has no affect on `static` positions.
         */
    top: _propTypes.default.any,

    /**
         * Ending horizontal position when `fixed` position.
         * Has no affect on `static` or `sticky` positions.
         */
    right: _propTypes.default.any,

    /**
         * Starting vertical position when `fixed` position.
         * Offset from the bottom of the window when `sticky` position.
         * Has no affect on `static` positions.
         */
    bottom: _propTypes.default.any,

    /**
         * Starting horizontal position when `fixed` position.
         * Has no affect on `static` or `sticky` positions.
         */
    left: _propTypes.default.any
  }),

  /**
     * Stretches or restricts the height to 100% of the parent;
     * `true`: scrolls the EuiPageContentBody;
     * `noscroll`: removes all scroll ability;
     * Only works when `template = 'default | empty'` and breakpoint is `m` and above
     */
  fullHeight: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["noscroll"])]),

  /**
     * Minimum height in which to enforce scrolling
     */
  minHeight: _propTypes.default.any
};