"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._EuiPageInner = void 0;

var _react = _interopRequireDefault(require("react"));

var _global_styling = require("../../../global_styling");

var _services = require("../../../services");

var _page_inner = require("./page_inner.styles");

var _react2 = require("@emotion/react");

var _excluded = ["children", "component", "panelled", "border", "paddingSize", "responsive"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var _EuiPageInner = function _EuiPageInner(_ref) {
  var children = _ref.children,
      _ref$component = _ref.component,
      Component = _ref$component === void 0 ? 'main' : _ref$component,
      panelled = _ref.panelled,
      border = _ref.border,
      _ref$paddingSize = _ref.paddingSize,
      paddingSize = _ref$paddingSize === void 0 ? 'none' : _ref$paddingSize,
      _ref$responsive = _ref.responsive,
      responsive = _ref$responsive === void 0 ? ['xs', 's'] : _ref$responsive,
      rest = _objectWithoutProperties(_ref, _excluded);

  var themeContext = (0, _services.useEuiTheme)();
  var isResponding = (0, _services.useIsWithinBreakpoints)(responsive);
  var styles = (0, _page_inner.euiPageInnerStyles)(themeContext);
  var paddingStyles = (0, _global_styling.useEuiPaddingCSS)()[paddingSize];
  var borderSide;

  if (border && isResponding) {
    borderSide = 'top';
  } else if (border) {
    borderSide = 'left';
  }

  var cssStyles = [styles.euiPageInner, paddingStyles, panelled && styles.panelled, borderSide && styles.border[borderSide]];
  return (// @ts-expect-error Generic element type mismatch
    (0, _react2.jsx)(Component, _extends({
      css: cssStyles
    }, rest), children)
  );
};

exports._EuiPageInner = _EuiPageInner;