"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._EuiPageOuter = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _services = require("../../../services");

var _page_outer = require("./page_outer.styles");

var _react2 = require("@emotion/react");

var _excluded = ["children", "grow", "direction", "responsive"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var _EuiPageOuter = function _EuiPageOuter(_ref) {
  var children = _ref.children,
      _ref$grow = _ref.grow,
      grow = _ref$grow === void 0 ? true : _ref$grow,
      _ref$direction = _ref.direction,
      direction = _ref$direction === void 0 ? 'row' : _ref$direction,
      _ref$responsive = _ref.responsive,
      responsive = _ref$responsive === void 0 ? ['xs', 's'] : _ref$responsive,
      rest = _objectWithoutProperties(_ref, _excluded);

  var themeContext = (0, _services.useEuiTheme)();
  var styles = (0, _page_outer.euiPageOuterStyles)(themeContext);
  var isResponding = (0, _services.useIsWithinBreakpoints)(responsive);
  var cssStyles = [styles.euiPageOuter, styles[isResponding ? 'column' : direction], grow && styles.grow];
  return (0, _react2.jsx)("div", _extends({
    css: cssStyles
  }, rest), children);
};

exports._EuiPageOuter = _EuiPageOuter;
_EuiPageOuter.propTypes = {
  /**
     * Adds `flex-grow: 1` to the whole page for stretching to fit vertically.
     * Must be wrapped inside a flexbox, preferrably with `min-height: 100vh`
     */
  grow: _propTypes.default.bool,

  /**
     * Changes the `flex-direction` property.
     * Flip to `column` when not including a sidebar.
     */
  direction: _propTypes.default.oneOf(["row", "column"]),

  /**
     * When direction is `row`, it will flip to `column` when within these breakpoints
     */
  responsive: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};