"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CurrentEuiBreakpointProvider = exports.CurrentEuiBreakpointContext = void 0;

var _react = _interopRequireWildcard(require("react"));

var _common = require("../../components/common");

var _theme = require("../theme");

var _throttle = require("../throttle");

var _sorting = require("./_sorting");

var _react2 = require("@emotion/react");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var CurrentEuiBreakpointContext = /*#__PURE__*/(0, _react.createContext)(undefined);
/**
 * Top level provider (nested within EuiProvider) which provides a single
 * resize listener that returns the current breakpoint based on window width
 */

exports.CurrentEuiBreakpointContext = CurrentEuiBreakpointContext;

var CurrentEuiBreakpointProvider = function CurrentEuiBreakpointProvider(_ref) {
  var children = _ref.children;

  // Obtain the breakpoints map from the EUI theme
  var _useEuiTheme = (0, _theme.useEuiTheme)(),
      breakpoints = _useEuiTheme.euiTheme.breakpoint; // Ensure the breakpoints map is sorted from largest value to smallest


  var sortedBreakpoints = (0, _react.useMemo)(function () {
    return (0, _sorting.sortMapByLargeToSmallValues)(breakpoints);
  }, [breakpoints]); // Find the breakpoint (key) whose value is <= windowWidth starting with largest first

  var getBreakpoint = (0, _react.useCallback)(function (width) {
    return (0, _common.keysOf)(sortedBreakpoints).find(function (key) {
      return sortedBreakpoints[key] <= width;
    });
  }, [sortedBreakpoints]);

  var _useState = (0, _react.useState)(typeof window !== 'undefined' ? getBreakpoint(window.innerWidth) : undefined),
      _useState2 = _slicedToArray(_useState, 2),
      currentBreakpoint = _useState2[0],
      setCurrentBreakpoint = _useState2[1];

  (0, _react.useEffect)(function () {
    var onWindowResize = (0, _throttle.throttle)(function () {
      setCurrentBreakpoint(getBreakpoint(window.innerWidth));
    }, 50);
    window.addEventListener('resize', onWindowResize);
    return function () {
      return window.removeEventListener('resize', onWindowResize);
    };
  }, [getBreakpoint]);
  return (0, _react2.jsx)(CurrentEuiBreakpointContext.Provider, {
    value: currentBreakpoint
  }, children);
};

exports.CurrentEuiBreakpointProvider = CurrentEuiBreakpointProvider;