import _createClass from "@babel/runtime/helpers/createClass";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _inherits from "@babel/runtime/helpers/inherits";
import _createSuper from "@babel/runtime/helpers/createSuper";
import _wrapNativeSuper from "@babel/runtime/helpers/wrapNativeSuper";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Custom error to report the error message with an additional error code.
 */
export var ErrorWithCode = /*#__PURE__*/function (_Error) {
  _inherits(ErrorWithCode, _Error);

  var _super = _createSuper(ErrorWithCode);

  /**
   * Constructor of the error.
   * @param message The error message.
   * @param code The code of the error.
   */
  function ErrorWithCode(message, code) {
    var _this;

    _classCallCheck(this, ErrorWithCode);

    _this = _super.call(this, message);
    _this.code = code;
    return _this;
  }

  return _createClass(ErrorWithCode);
}( /*#__PURE__*/_wrapNativeSuper(Error));