import _objectSpread from "@babel/runtime/helpers/objectSpread2";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import moment from 'moment-timezone';
import { wrapArray } from './util';
import { ApplicationUsageTracker } from './application_usage_tracker';
import { METRIC_TYPE } from './metrics';
var REPORT_VERSION = 3;
export var ReportManager = /*#__PURE__*/function () {
  function ReportManager(report) {
    _classCallCheck(this, ReportManager);

    _defineProperty(this, "report", void 0);

    this.report = report || ReportManager.createReport();
  }

  _createClass(ReportManager, [{
    key: "clearReport",
    value: function clearReport() {
      this.report = ReportManager.createReport();
    }
  }, {
    key: "isReportEmpty",
    value: function isReportEmpty() {
      var _this$report = this.report,
          uiCounter = _this$report.uiCounter,
          userAgent = _this$report.userAgent,
          appUsage = _this$report.application_usage;
      var noUiCounters = !uiCounter || Object.keys(uiCounter).length === 0;
      var noUserAgents = !userAgent || Object.keys(userAgent).length === 0;
      var noAppUsage = !appUsage || Object.keys(appUsage).length === 0;
      return noUiCounters && noUserAgents && noAppUsage;
    }
  }, {
    key: "incrementTotal",
    value: function incrementTotal(count, currentTotal) {
      var currentTotalNumber = typeof currentTotal === 'number' ? currentTotal : 0;
      return count + currentTotalNumber;
    }
  }, {
    key: "assignReports",
    value: function assignReports(newMetrics) {
      var _this = this;

      wrapArray(newMetrics).forEach(function (newMetric) {
        return _this.assignReport(_this.report, newMetric);
      });
      return {
        report: this.report
      };
    }
  }, {
    key: "assignReport",
    value: function assignReport(report, metric) {
      var _report$uiCounter$key;

      var key = ReportManager.createMetricKey(metric);

      switch (metric.type) {
        case METRIC_TYPE.USER_AGENT:
          {
            var _ref = metric,
                _appName = _ref.appName,
                _type = _ref.type,
                userAgent = _ref.userAgent;

            if (userAgent) {
              report.userAgent = _defineProperty({}, key, {
                key: key,
                appName: _appName,
                type: _type,
                userAgent: userAgent
              });
            }

            return;
          }

        case METRIC_TYPE.APPLICATION_USAGE:
          {
            var _ref2 = metric,
                numberOfClicks = _ref2.numberOfClicks,
                startTime = _ref2.startTime,
                appId = _ref2.appId,
                viewId = _ref2.viewId;
            var minutesOnScreen = moment().diff(startTime, 'minutes', true);
            report.application_usage = report.application_usage || {};
            var appExistingData = report.application_usage[key] || {
              minutesOnScreen: 0,
              numberOfClicks: 0,
              appId: appId,
              viewId: viewId
            };
            report.application_usage[key] = _objectSpread(_objectSpread({}, appExistingData), {}, {
              minutesOnScreen: appExistingData.minutesOnScreen + minutesOnScreen,
              numberOfClicks: appExistingData.numberOfClicks + numberOfClicks
            });
            return;
          }

        default:
          var _ref3 = metric,
              appName = _ref3.appName,
              type = _ref3.type,
              eventName = _ref3.eventName,
              count = _ref3.count;
          report.uiCounter = report.uiCounter || {};
          var currentTotal = (_report$uiCounter$key = report.uiCounter[key]) === null || _report$uiCounter$key === void 0 ? void 0 : _report$uiCounter$key.total;
          report.uiCounter[key] = {
            key: key,
            appName: appName,
            eventName: eventName,
            type: type,
            total: this.incrementTotal(count, currentTotal)
          };
          return;
      }
    }
  }], [{
    key: "createReport",
    value: function createReport() {
      return {
        reportVersion: REPORT_VERSION
      };
    }
  }, {
    key: "createMetricKey",
    value: function createMetricKey(metric) {
      switch (metric.type) {
        case METRIC_TYPE.USER_AGENT:
          {
            var _appName2 = metric.appName,
                _type2 = metric.type;
            return "".concat(_appName2, "-").concat(_type2);
          }

        case METRIC_TYPE.APPLICATION_USAGE:
          {
            var _ref4 = metric,
                appId = _ref4.appId,
                viewId = _ref4.viewId;
            return ApplicationUsageTracker.serializeKey({
              appId: appId,
              viewId: viewId
            });
          }

        default:
          var _ref5 = metric,
              appName = _ref5.appName,
              eventName = _ref5.eventName,
              type = _ref5.type;
          return "".concat(appName, "-").concat(type, "-").concat(eventName);
      }
    }
  }]);

  return ReportManager;
}();

_defineProperty(ReportManager, "REPORT_VERSION", REPORT_VERSION);