"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorRanges = ColorRanges;

var _react = _interopRequireWildcard(require("react"));

var _lodash = require("lodash");

var _eui = require("@elastic/eui");

var _palettes = require("../../../palettes");

var _color_ranges_extra_actions = require("./color_ranges_extra_actions");

var _color_ranges_item = require("./color_ranges_item");

var _color_ranges_validation = require("./color_ranges_validation");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function ColorRanges({
  colorRanges,
  paletteConfiguration,
  showExtraActions,
  dispatch
}) {
  var _paletteConfiguration, _paletteConfiguration2;

  const [colorRangesValidity, setColorRangesValidity] = (0, _react.useState)({});
  const lastColorRange = colorRanges[colorRanges.length - 1];
  const errors = (0, _color_ranges_validation.getErrorMessages)(colorRangesValidity);
  const continuity = (_paletteConfiguration = paletteConfiguration === null || paletteConfiguration === void 0 ? void 0 : paletteConfiguration.continuity) !== null && _paletteConfiguration !== void 0 ? _paletteConfiguration : _palettes.DEFAULT_CONTINUITY;
  const rangeType = (_paletteConfiguration2 = paletteConfiguration === null || paletteConfiguration === void 0 ? void 0 : paletteConfiguration.rangeType) !== null && _paletteConfiguration2 !== void 0 ? _paletteConfiguration2 : _palettes.DEFAULT_RANGE_TYPE;
  (0, _react.useEffect)(() => {
    setColorRangesValidity((0, _color_ranges_validation.validateColorRanges)(colorRanges, rangeType === 'percent'));
  }, [colorRanges, rangeType]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": `lnsPalettePanel_dynamicColoring_custom_color_ranges`,
    direction: "column",
    gutterSize: "s"
  }, colorRanges.map((colorRange, index) => {
    var _ref, _colorRange$end;

    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: `${(_ref = (_colorRange$end = colorRange.end) !== null && _colorRange$end !== void 0 ? _colorRange$end : 0 + colorRange.start) !== null && _ref !== void 0 ? _ref : 0}${index}`
    }, /*#__PURE__*/_react.default.createElement(_color_ranges_item.ColorRangeItem, {
      colorRange: colorRange,
      dispatch: dispatch,
      colorRanges: colorRanges,
      continuity: continuity,
      rangeType: rangeType,
      index: index,
      validation: colorRangesValidity[index],
      accessor: "start"
    }));
  }), lastColorRange ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_color_ranges_item.ColorRangeItem, {
    colorRange: lastColorRange,
    dispatch: dispatch,
    colorRanges: colorRanges,
    continuity: continuity,
    rangeType: rangeType,
    index: colorRanges.length - 1,
    validation: colorRangesValidity.last,
    accessor: "end"
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, errors.map(error => /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "danger",
    key: `${(0, _lodash.camelCase)(error)}`
  }, error))), showExtraActions ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_color_ranges_extra_actions.ColorRangesExtraActions, {
    dispatch: dispatch,
    shouldDisableAdd: Boolean((paletteConfiguration === null || paletteConfiguration === void 0 ? void 0 : paletteConfiguration.maxSteps) && colorRanges.length >= (paletteConfiguration === null || paletteConfiguration === void 0 ? void 0 : paletteConfiguration.maxSteps) || errors.length),
    shouldDisableDistribute: Boolean(colorRanges.length === 1),
    shouldDisableReverse: Boolean(colorRanges.length === 1)
  })) : null);
}