"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.paletteConfigurationReducer = void 0;

var _palettes = require("../../palettes");

var _utils = require("./color_ranges/utils");

var _utils2 = require("./utils");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const paletteConfigurationReducer = (state, action) => {
  switch (action.type) {
    case 'updateContinuity':
      {
        var _state$activePalette$, _state$activePalette$2;

        const {
          continuity,
          isLast,
          dataBounds,
          palettes
        } = action.payload;
        const rangeType = (_state$activePalette$ = (_state$activePalette$2 = state.activePalette.params) === null || _state$activePalette$2 === void 0 ? void 0 : _state$activePalette$2.rangeType) !== null && _state$activePalette$ !== void 0 ? _state$activePalette$ : _palettes.DEFAULT_RANGE_TYPE;
        const value = (0, _utils.getValueForContinuity)(state.colorRanges, continuity, isLast, rangeType, dataBounds);
        return (0, _utils2.withUpdatingPalette)(palettes, state.activePalette, (0, _utils.updateColorRangeValue)(isLast ? state.colorRanges.length - 1 : 0, `${value}`, isLast ? 'end' : 'start', state.colorRanges), dataBounds, continuity);
      }

    case 'addColorRange':
      {
        var _state$activePalette$3, _state$activePalette$4;

        const {
          dataBounds,
          palettes
        } = action.payload;
        return (0, _utils2.withUpdatingPalette)(palettes, state.activePalette, (0, _utils.addColorRange)(state.colorRanges, (_state$activePalette$3 = (_state$activePalette$4 = state.activePalette.params) === null || _state$activePalette$4 === void 0 ? void 0 : _state$activePalette$4.rangeType) !== null && _state$activePalette$3 !== void 0 ? _state$activePalette$3 : _palettes.DEFAULT_RANGE_TYPE, dataBounds), dataBounds);
      }

    case 'reversePalette':
      {
        const {
          dataBounds,
          palettes
        } = action.payload;
        return (0, _utils2.withUpdatingPalette)(palettes, state.activePalette, (0, _utils.reversePalette)(state.colorRanges), dataBounds);
      }

    case 'distributeEqually':
      {
        var _state$activePalette$5, _state$activePalette$6, _state$activePalette$7;

        const {
          dataBounds,
          palettes
        } = action.payload;
        return (0, _utils2.withUpdatingPalette)(palettes, state.activePalette, (0, _utils.distributeEqually)(state.colorRanges, (_state$activePalette$5 = state.activePalette.params) === null || _state$activePalette$5 === void 0 ? void 0 : _state$activePalette$5.rangeType, (_state$activePalette$6 = (_state$activePalette$7 = state.activePalette.params) === null || _state$activePalette$7 === void 0 ? void 0 : _state$activePalette$7.continuity) !== null && _state$activePalette$6 !== void 0 ? _state$activePalette$6 : _palettes.DEFAULT_CONTINUITY, dataBounds), dataBounds);
      }

    case 'updateColor':
      {
        const {
          index,
          color,
          palettes,
          dataBounds
        } = action.payload;
        return (0, _utils2.withUpdatingPalette)(palettes, state.activePalette, (0, _utils.updateColorRangeColor)(index, color, state.colorRanges), dataBounds);
      }

    case 'sortColorRanges':
      {
        const {
          dataBounds,
          palettes
        } = action.payload;
        return (0, _utils2.withUpdatingPalette)(palettes, state.activePalette, (0, _utils.sortColorRanges)(state.colorRanges), dataBounds);
      }

    case 'updateValue':
      {
        const {
          index,
          value,
          accessor,
          dataBounds,
          palettes
        } = action.payload;
        return (0, _utils2.withUpdatingPalette)(palettes, state.activePalette, (0, _utils.updateColorRangeValue)(index, value, accessor, state.colorRanges), dataBounds);
      }

    case 'deleteColorRange':
      {
        const {
          index,
          dataBounds,
          palettes
        } = action.payload;
        return (0, _utils2.withUpdatingPalette)(palettes, state.activePalette, (0, _utils.deleteColorRange)(index, state.colorRanges), dataBounds);
      }

    case 'updateRangeType':
      {
        const {
          dataBounds,
          palettes,
          rangeType
        } = action.payload;
        const paletteParams = (0, _utils2.updateRangeType)(rangeType, state.activePalette, dataBounds, palettes, state.colorRanges);
        const newPalette = (0, _utils2.mergePaletteParams)(state.activePalette, paletteParams);
        return (0, _utils2.withUpdatingColorRanges)(palettes, newPalette, dataBounds);
      }

    case 'changeColorPalette':
      {
        const {
          dataBounds,
          palettes,
          palette,
          disableSwitchingContinuity
        } = action.payload;
        const newPalette = (0, _utils2.changeColorPalette)(palette, state.activePalette, palettes, dataBounds, disableSwitchingContinuity);
        return (0, _utils2.withUpdatingColorRanges)(palettes, newPalette, dataBounds);
      }

    default:
      throw new Error('wrong action');
  }
};

exports.paletteConfigurationReducer = paletteConfigurationReducer;