/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n-react';
import React, { useCallback, useContext } from 'react';
import { EuiFlexGroup, EuiButtonEmpty, EuiFlexItem } from '@elastic/eui';
import { DistributeEquallyIcon } from '../assets/distribute_equally';
import { TooltipWrapper } from '../tooltip_wrapper';
import { ColorRangesContext } from './color_ranges_context';
import { jsx as ___EmotionJSX } from "@emotion/react";
export function ColorRangesExtraActions(_ref) {
  var dispatch = _ref.dispatch,
      _ref$shouldDisableAdd = _ref.shouldDisableAdd,
      shouldDisableAdd = _ref$shouldDisableAdd === void 0 ? false : _ref$shouldDisableAdd,
      _ref$shouldDisableRev = _ref.shouldDisableReverse,
      shouldDisableReverse = _ref$shouldDisableRev === void 0 ? false : _ref$shouldDisableRev,
      _ref$shouldDisableDis = _ref.shouldDisableDistribute,
      shouldDisableDistribute = _ref$shouldDisableDis === void 0 ? false : _ref$shouldDisableDis;

  var _useContext = useContext(ColorRangesContext),
      dataBounds = _useContext.dataBounds,
      palettes = _useContext.palettes;

  var onAddColorRange = useCallback(function () {
    dispatch({
      type: 'addColorRange',
      payload: {
        dataBounds: dataBounds,
        palettes: palettes
      }
    });
  }, [dataBounds, dispatch, palettes]);
  var onReversePalette = useCallback(function () {
    dispatch({
      type: 'reversePalette',
      payload: {
        dataBounds: dataBounds,
        palettes: palettes
      }
    });
  }, [dispatch, dataBounds, palettes]);
  var onDistributeValues = useCallback(function () {
    dispatch({
      type: 'distributeEqually',
      payload: {
        dataBounds: dataBounds,
        palettes: palettes
      }
    });
  }, [dataBounds, dispatch, palettes]);
  var oneColorRangeWarn = i18n.translate('coloring.dynamicColoring.customPalette.oneColorRange', {
    defaultMessage: "Requires more than one color"
  });
  return ___EmotionJSX(EuiFlexGroup, {
    justifyContent: "flexStart",
    gutterSize: "m",
    wrap: true
  }, ___EmotionJSX(EuiFlexItem, {
    grow: false
  }, ___EmotionJSX(TooltipWrapper, {
    tooltipContent: i18n.translate('coloring.dynamicColoring.customPalette.maximumStepsApplied', {
      defaultMessage: "You've applied the maximum number of steps"
    }),
    condition: shouldDisableAdd,
    position: "top",
    delay: "regular"
  }, ___EmotionJSX(EuiButtonEmpty, {
    "data-test-subj": "lnsPalettePanel_dynamicColoring_addColor",
    iconType: "plusInCircle",
    color: "primary",
    "aria-label": i18n.translate('coloring.dynamicColoring.customPalette.addColorAriaLabel', {
      defaultMessage: 'Add color'
    }),
    size: "xs",
    flush: "left",
    disabled: shouldDisableAdd,
    onClick: onAddColorRange
  }, ___EmotionJSX(FormattedMessage, {
    id: "coloring.dynamicColoring.customPalette.addColor",
    defaultMessage: "Add color"
  })))), ___EmotionJSX(EuiFlexItem, {
    grow: false
  }, ___EmotionJSX(TooltipWrapper, {
    tooltipContent: oneColorRangeWarn,
    condition: shouldDisableReverse,
    position: "top",
    delay: "regular"
  }, ___EmotionJSX(EuiButtonEmpty, {
    "data-test-subj": "lnsPalettePanel_dynamicColoring_reverseColors",
    iconType: "sortable",
    color: "primary",
    "aria-label": i18n.translate('coloring.dynamicColoring.customPaletteAriaLabel', {
      defaultMessage: 'Reverse colors'
    }),
    size: "xs",
    flush: "left",
    onClick: onReversePalette,
    disabled: shouldDisableReverse
  }, ___EmotionJSX(FormattedMessage, {
    id: "coloring.dynamicColoring.customPalette.reverseColors",
    defaultMessage: "Reverse colors"
  })))), ___EmotionJSX(EuiFlexItem, {
    grow: false
  }, ___EmotionJSX(TooltipWrapper, {
    tooltipContent: oneColorRangeWarn,
    condition: shouldDisableDistribute,
    position: "top",
    delay: "regular"
  }, ___EmotionJSX(EuiButtonEmpty, {
    "data-test-subj": "lnsPalettePanel_dynamicColoring_distributeValues",
    iconType: DistributeEquallyIcon,
    color: "primary",
    "aria-label": i18n.translate('coloring.dynamicColoring.customPalette.distributeValuesAriaLabel', {
      defaultMessage: 'Distribute values'
    }),
    size: "xs",
    flush: "left",
    disabled: shouldDisableDistribute,
    onClick: onDistributeValues
  }, ___EmotionJSX(FormattedMessage, {
    id: "coloring.dynamicColoring.customPalette.distributeValues",
    defaultMessage: "Distribute values"
  })))));
}