"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NumberType = void 0;

var _typeDetect = _interopRequireDefault(require("type-detect"));

var _internals = require("../internals");

var _type = require("./type");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
class NumberType extends _type.Type {
  constructor(options = {}) {
    let schema = _internals.internals.number();

    if (options.min !== undefined) {
      schema = schema.min(options.min);
    }

    if (options.max !== undefined) {
      schema = schema.max(options.max);
    }

    super(schema, options);
  }

  handleError(type, {
    limit,
    value
  }) {
    switch (type) {
      case 'any.required':
      case 'number.base':
        return `expected value of type [number] but got [${(0, _typeDetect.default)(value)}]`;

      case 'number.min':
        return `Value must be equal to or greater than [${limit}].`;

      case 'number.max':
        return `Value must be equal to or lower than [${limit}].`;
    }
  }

}

exports.NumberType = NumberType;