"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StringType = void 0;

var _typeDetect = _interopRequireDefault(require("type-detect"));

var _internals = require("../internals");

var _type = require("./type");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
class StringType extends _type.Type {
  constructor(options = {}) {
    // We want to allow empty strings, however calling `allow('')` causes
    // Joi to allow the value and skip any additional validation.
    // Instead, we reimplement the string validator manually except in the
    // hostname case where empty strings aren't allowed anyways.
    let schema = options.hostname === true ? _internals.internals.string().hostname() : _internals.internals.any().custom((0, _type.convertValidationFunction)(value => {
      if (typeof value !== 'string') {
        return `expected value of type [string] but got [${(0, _typeDetect.default)(value)}]`;
      }
    }));

    if (options.minLength !== undefined) {
      schema = schema.custom((0, _type.convertValidationFunction)(value => {
        if (value.length < options.minLength) {
          return `value has length [${value.length}] but it must have a minimum length of [${options.minLength}].`;
        }
      }));
    }

    if (options.maxLength !== undefined) {
      schema = schema.custom((0, _type.convertValidationFunction)(value => {
        if (value.length > options.maxLength) {
          return `value has length [${value.length}] but it must have a maximum length of [${options.maxLength}].`;
        }
      }));
    }

    schema.type = 'string';
    super(schema, options);
  }

  handleError(type, {
    limit,
    value
  }) {
    switch (type) {
      case 'any.required':
        return `expected value of type [string] but got [${(0, _typeDetect.default)(value)}]`;

      case 'string.hostname':
        return `value must be a valid hostname (see RFC 1123).`;
    }
  }

}

exports.StringType = StringType;