/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { i18n } from '@kbn/i18n';

/** @public */
export var DEFAULT_APP_CATEGORIES = Object.freeze({
  kibana: {
    id: 'kibana',
    label: i18n.translate('core.ui.kibanaNavList.label', {
      defaultMessage: 'Analytics'
    }),
    euiIconType: 'logoKibana',
    order: 1000
  },
  enterpriseSearch: {
    id: 'enterpriseSearch',
    label: i18n.translate('core.ui.enterpriseSearchNavList.label', {
      defaultMessage: 'Enterprise Search'
    }),
    order: 2000,
    euiIconType: 'logoEnterpriseSearch'
  },
  observability: {
    id: 'observability',
    label: i18n.translate('core.ui.observabilityNavList.label', {
      defaultMessage: 'Observability'
    }),
    euiIconType: 'logoObservability',
    order: 3000
  },
  security: {
    id: 'securitySolution',
    label: i18n.translate('core.ui.securityNavList.label', {
      defaultMessage: 'Security'
    }),
    order: 4000,
    euiIconType: 'logoSecurity'
  },
  management: {
    id: 'management',
    label: i18n.translate('core.ui.managementNavList.label', {
      defaultMessage: 'Management'
    }),
    order: 5000,
    euiIconType: 'managementApp'
  }
});