"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.adoptToHapiOnPreAuth = adoptToHapiOnPreAuth;

var _coreHttpServer = require("@kbn/core-http-server");

var _coreHttpRouterServerInternal = require("@kbn/core-http-router-server-internal");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const preAuthResult = {
  next() {
    return {
      type: _coreHttpServer.OnPreAuthResultType.next
    };
  },

  isNext(result) {
    return result && result.type === _coreHttpServer.OnPreAuthResultType.next;
  }

};
const toolkit = {
  next: preAuthResult.next
};
/**
 * Adopt custom request interceptor to Hapi lifecycle system.
 * @param fn - an extension point allowing to perform custom logic for
 * incoming HTTP requests before a user has been authenticated.
 */

function adoptToHapiOnPreAuth(fn, log) {
  return async function interceptPreAuthRequest(request, responseToolkit) {
    const hapiResponseAdapter = new _coreHttpRouterServerInternal.HapiResponseAdapter(responseToolkit);

    try {
      const result = await fn(_coreHttpRouterServerInternal.CoreKibanaRequest.from(request), _coreHttpRouterServerInternal.lifecycleResponseFactory, toolkit);

      if ((0, _coreHttpRouterServerInternal.isKibanaResponse)(result)) {
        return hapiResponseAdapter.handle(result);
      }

      if (preAuthResult.isNext(result)) {
        return responseToolkit.continue;
      }

      throw new Error(`Unexpected result from OnPreAuth. Expected OnPreAuthResult or KibanaResponse, but given: ${result}.`);
    } catch (error) {
      log.error(error);
      return hapiResponseAdapter.toInternalError();
    }
  };
}