"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nodeConfig = exports.NODE_WILDCARD_CHAR = exports.NODE_CONFIG_PATH = exports.NODE_ACCEPTED_ROLES = void 0;

var _configSchema = require("@kbn/config-schema");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */
const NODE_CONFIG_PATH = 'node';
/** @internal */

exports.NODE_CONFIG_PATH = NODE_CONFIG_PATH;
const NODE_WILDCARD_CHAR = '*';
/** @internal */

exports.NODE_WILDCARD_CHAR = NODE_WILDCARD_CHAR;
const NODE_ACCEPTED_ROLES = ['background_tasks', 'ui'];
/** @internal */

exports.NODE_ACCEPTED_ROLES = NODE_ACCEPTED_ROLES;

const configSchema = _configSchema.schema.object({
  roles: _configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal('background_tasks'), _configSchema.schema.literal('ui')])), _configSchema.schema.arrayOf(_configSchema.schema.literal(NODE_WILDCARD_CHAR), {
    minSize: 1,
    maxSize: 1
  })], {
    defaultValue: [NODE_WILDCARD_CHAR]
  })
});

const nodeConfig = {
  path: NODE_CONFIG_PATH,
  schema: configSchema
};
exports.nodeConfig = nodeConfig;