"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortObjects = sortObjects;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const getId = object => `${object.type}:${object.id}`;

function sortObjects(savedObjects) {
  const traversed = new Set();
  const sorted = new Set();
  const objectsByTypeId = new Map(savedObjects.map(object => [getId(object), object]));

  function includeObjects(objects) {
    for (const object of objects) {
      const objectId = getId(object);

      if (traversed.has(objectId)) {
        continue;
      }

      const objectRefs = object.references.map(ref => objectsByTypeId.get(getId(ref))).filter(ref => !!ref);
      traversed.add(objectId);

      if (objectRefs.length) {
        includeObjects(objectRefs);
      }

      sorted.add(object);
    }
  }

  includeObjects(savedObjects);
  return [...sorted];
}