"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.excludeUnusedTypesQuery = exports.REMOVED_TYPES = void 0;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Types that are no longer registered and need to be removed
 */
const REMOVED_TYPES = ['apm-services-telemetry', 'background-session', 'cases-sub-case', 'file-upload-telemetry', // https://github.com/elastic/kibana/issues/91869
'fleet-agent-events', // https://github.com/elastic/obs-dc-team/issues/334
'fleet-agents', 'fleet-agent-actions', 'fleet-enrollment-api-keys', // Was removed in 7.12
'ml-telemetry', 'server', // https://github.com/elastic/kibana/issues/95617
'tsvb-validation-telemetry', // replaced by osquery-manager-usage-metric
'osquery-usage-metric', // Was removed in 8.1 https://github.com/elastic/kibana/issues/91265
'siem-detection-engine-rule-status', // Was removed in 7.16
'timelion-sheet', // Removed in 8.3 https://github.com/elastic/kibana/issues/127745
'ui-counter', // Deprecated, no longer used since 7.13 https://github.com/elastic/kibana/pull/94923/files
'application_usage_transactional'].sort(); // When migrating from the outdated index we use a read query which excludes
// saved objects which are no longer used. These saved objects will still be
// kept in the outdated index for backup purposes, but won't be available in
// the upgraded index.

exports.REMOVED_TYPES = REMOVED_TYPES;
const excludeUnusedTypesQuery = {
  bool: {
    must_not: [...REMOVED_TYPES.map(typeName => ({
      term: {
        type: typeName
      }
    })), // https://github.com/elastic/kibana/issues/96131
    {
      bool: {
        must: [{
          match: {
            type: 'search-session'
          }
        }, {
          match: {
            'search-session.persisted': false
          }
        }]
      }
    }]
  }
};
exports.excludeUnusedTypesQuery = excludeUnusedTypesQuery;