"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDeprecationsSetupMock = exports.createDeprecationRegistryProviderMock = exports.createCoreUsageDataSetupMock = void 0;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const createDeprecationsSetupMock = () => {
  const setupContract = {
    registerDeprecations: jest.fn()
  };
  return setupContract;
};

exports.createDeprecationsSetupMock = createDeprecationsSetupMock;

const createDeprecationRegistryProviderMock = () => {
  const internalSetupContract = {
    getRegistry: jest.fn()
  };
  internalSetupContract.getRegistry.mockReturnValue(createDeprecationsSetupMock());
  return internalSetupContract;
};

exports.createDeprecationRegistryProviderMock = createDeprecationRegistryProviderMock;

const createCoreUsageDataSetupMock = () => {
  const setupContract = {
    registerType: jest.fn(),
    getClient: jest.fn(),
    registerUsageCounter: jest.fn(),
    incrementUsageCounter: jest.fn()
  };
  return setupContract;
};

exports.createCoreUsageDataSetupMock = createCoreUsageDataSetupMock;