"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerPerformanceMetricEventType = registerPerformanceMetricEventType;
exports.reportPerformanceMetricEvent = reportPerformanceMetricEvent;

var _schema = require("./schema");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const PERFORMANCE_METRIC_EVENT_TYPE = 'performance_metric';
/**
 * Register the `performance_metric` event type
 * @param analytics The {@link AnalyticsClient} during the setup phase (it has the method `registerEventType`)
 * @private To be called only by core's Analytics Service
 */

function registerPerformanceMetricEventType(analytics) {
  analytics.registerEventType({
    eventType: PERFORMANCE_METRIC_EVENT_TYPE,
    schema: _schema.METRIC_EVENT_SCHEMA
  });
}
/**
 * Report a `performance_metric` event type.
 * @param analytics The {@link AnalyticsClient} to report the events.
 * @param eventData The data to send, conforming the structure of a {@link MetricEvent}.
 */


function reportPerformanceMetricEvent(analytics, eventData) {
  analytics.reportEvent(PERFORMANCE_METRIC_EVENT_TYPE, eventData);
}