"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KQL_NODE_TYPE_LITERAL = void 0;
exports.buildNode = buildNode;
exports.isNode = isNode;
exports.toElasticsearchQuery = toElasticsearchQuery;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const KQL_NODE_TYPE_LITERAL = 'literal';
exports.KQL_NODE_TYPE_LITERAL = KQL_NODE_TYPE_LITERAL;

function isNode(node) {
  return node.type === KQL_NODE_TYPE_LITERAL;
}

function buildNode(value, isQuoted = false) {
  return {
    type: KQL_NODE_TYPE_LITERAL,
    value,
    isQuoted
  };
}

function toElasticsearchQuery(node) {
  return node.value;
}