/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
export var KQL_NODE_TYPE_LITERAL = 'literal';
export function isNode(node) {
  return node.type === KQL_NODE_TYPE_LITERAL;
}
export function buildNode(value) {
  var isQuoted = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  return {
    type: KQL_NODE_TYPE_LITERAL,
    value: value,
    isQuoted: isQuoted
  };
}
export function toElasticsearchQuery(node) {
  return node.value;
}